/*
	Author: Hellr0ck
	Version: 0.1
	Date: 02/07/2011

	Description: Plugin setup random GameName from file, every map start

	Cvars: No Cvars

	Requirements:
	- FakeMeta module

	ChangeLog:
	0.1:
	- First Release
	0.2:
	- Optimized code
	- Replaced write_file -> fputs (creator_52)

	Credits:
	- NeuroToxin - Thanks for part of code from GameNameChanger plugin! :D
	- creator_52 - Thanks for the suggestion to replace write_file to fputs! = D
*/

#include <amxmodx>
#include <amxmisc>
#include <fakemeta>

#define MAX_GAMENAMES 20     // Max number of GameNames, what can be loaded
#define MAX_GAMENAME_LEN 32  // Max lenght of GameName string

static const PLUGIN_NAME[] = "[HR] MapStart Random GameName";
static const PLUGIN_VERSION[] = "0.2";
static const PLUGIN_AUTHOR[] = "Hellr0ck";

new Array:g_aLoadedGameNames;
new g_szRandomGameName[MAX_GAMENAME_LEN];
new g_iGameNamesNum;

new const g_aNewFileContent[6][50] =
{
	"; This file was autogenerated^n",
	"; NewMap Random GameName plugin by Hellr0ck^n",
	"; Example to adding GameName string:^n",
	"^n",
	"Random GameName by Hellr0ck^n",
	"Random GameName v0.2^n"
};

public plugin_init()
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR);
	register_cvar(PLUGIN_NAME, PLUGIN_VERSION, FCVAR_SERVER | FCVAR_SPONLY);

	g_aLoadedGameNames = ArrayCreate(MAX_GAMENAME_LEN, 1);

	register_forward(FM_GetGameDescription, "fwd_GetGameDescription");
}

public plugin_cfg()
{
	new szGameNamesFile[64], iFile;
	get_configsdir(szGameNamesFile, charsmax(szGameNamesFile));
	add(szGameNamesFile, charsmax(szGameNamesFile), "/GameNames.ini");

	if(!file_exists(szGameNamesFile))
	{
		iFile = fopen(szGameNamesFile, "wt");

		if(iFile)
		{
			for(new iStr; iStr <= sizeof(g_aNewFileContent) - 1; iStr++)
			{
				fputs(iFile, g_aNewFileContent[iStr]);
			}
			fclose(iFile);
		}

		log_amx("File GameNames.ini doesn't exist, file was automatically created...");
	}

	iFile = fopen(szGameNamesFile, "r");

	if(iFile)
	{
		new szBuffer[MAX_GAMENAME_LEN];
		new iLen = charsmax(szBuffer);

		while(!feof(iFile))
		{
			if(g_iGameNamesNum >= MAX_GAMENAMES)
			{
				log_amx("Cannot load more than %i GameNames, loading from file has been stopped!", MAX_GAMENAMES);
				break;
			}

			fgets(iFile, szBuffer, iLen), trim(szBuffer), remove_quotes(szBuffer);

			if(szBuffer[0] == ';' || strlen(szBuffer) == 0)
				continue;

			ArrayPushString(g_aLoadedGameNames, szBuffer);

			g_iGameNamesNum++;
		}
		fclose(iFile);
	}

	if(g_iGameNamesNum)
	{
		ArrayGetString(g_aLoadedGameNames, random_num(0, g_iGameNamesNum - 1), g_szRandomGameName, charsmax(g_szRandomGameName));
		ArrayDestroy(g_aLoadedGameNames);
	}
}

public fwd_GetGameDescription()
{
	forward_return(FMV_STRING, g_szRandomGameName);
	return FMRES_SUPERCEDE;
}