/* Plugin Template generated by Pawn Studio */

#pragma semicolon 1

#include <sourcemod>

#define VERSION "1.0.0"

public Plugin:myinfo = 
{
	name = "Spec-Hop Money Block",
	author = "FlyingMongoose",
	description = "Prevents the gaining of money via spectator hopping.",
	version = VERSION,
	url = "http://www.interwavestudios.com/"
}

new Handle:cvarSpecPunishment;
new Handle:cvarSetMoneyValue;

new g_MoneyOffset;

new bool:FirstJoined[MAXPLAYERS+1];

new PlayersCash[MAXPLAYERS+1];

new bool:PlayerSpec[MAXPLAYERS+1];

new Handle:SpecTimer[MAXPLAYERS+1];

public OnPluginStart()
{
	g_MoneyOffset = FindSendPropInfo("CCSPlayer", "m_iAccount");
	if (g_MoneyOffset != -1)
	{
		CreateConVar("spec_hop_prevention_version",VERSION, _,FCVAR_PLUGIN|FCVAR_NOTIFY|FCVAR_REPLICATED|FCVAR_SPONLY);
		cvarSpecPunishment = CreateConVar("sm_spechoppunish","1","Sets punishment method for spectator hopping.\n0 = off\n1 = preserve money\n2 = set money",FCVAR_PLUGIN,true,0.0,true,2.0);
		cvarSetMoneyValue = CreateConVar("sm_spechopmoneyvalue","0","Sets the money value to set on the player who spec hops\nDefault = 0",FCVAR_PLUGIN,true,0.0,true,16000.0);
	
		HookEvent("player_spawn",PlayerSpawn);
		HookEvent("player_death",PlayerDeath);
		HookEvent("player_team",TeamChanged);
	}else{
		SetFailState("* FATAL ERROR: Failed to get offset for CCSPlayer::m_iAccount");
	}	
}

public OnConfigsExecuted()
{
	AutoExecConfig(true,"spechop");
}

public TeamChanged(Handle:event, const String:name[], bool:dontBroadcast)
{
	new SpecHopPunishVal = GetConVarInt(cvarSpecPunishment);
	if(SpecHopPunishVal == 0)
	{
		return;
	}
	else
	{
		if(GetEventBool(event,"disconnect"))
		{
			return;
		}
		else
		{
			new client = GetClientOfUserId(GetEventInt(event,"userid"));
			new newteam = GetEventInt(event,"team");
			if(FirstJoined[client])
			{
				FirstJoined[client] = false;
				return;
			}
			else
			{	
				if(SpecHopPunishVal != 0)
				{
					if(newteam == 1)
					{
						PlayerSpec[client] = true;
						new Handle:RoundTimer = FindConVar("mp_roundtime");
						new Float:SpecTime = GetConVarFloat(RoundTimer) * 60.0;
						SpecTimer[client] = CreateTimer(SpecTime,SpecTimerDone,client);
						return;
					}
					if(SpecHopPunishVal == 1 && PlayerSpec[client] && newteam != 1)
					{
						SetPlayerCash(client,PlayersCash[client]);
						if(SpecTimer[client] != INVALID_HANDLE)
						{
							KillTimer(SpecTimer[client]);
							SpecTimer[client] = INVALID_HANDLE;
						}
						return;
					}
					if(SpecHopPunishVal == 2 && PlayerSpec[client] && newteam != 1)
					{
						SetPlayerCash(client,GetConVarInt(cvarSetMoneyValue));
						if(SpecTimer[client] != INVALID_HANDLE)
						{
							KillTimer(SpecTimer[client]);
							SpecTimer[client] = INVALID_HANDLE;
						}
						return;
					}
				}
			}
		}
	}
}

public PlayerDeath(Handle:event, const String:name[], bool:dontBroadcast)
{
	new client = GetClientOfUserId(GetEventInt(event,"userid"));
	PlayersCash[client] = GetPlayerCash(client);
}

public Action:SpecTimerDone(Handle:timer,any:client){
	PlayerSpec[client] = false;
}

public PlayerSpawn(Handle:event, const String:name[], bool:dontBroadcast){
	new client = GetClientOfUserId(GetEventInt(event,"userid"));
	new SpecHopPunishVal = GetConVarInt(cvarSpecPunishment);
	if(SpecHopPunishVal == 1 && PlayerSpec[client])
	{
		SetPlayerCash(client,PlayersCash[client]);
		PlayerSpec[client] = false;
		if(SpecTimer[client] != INVALID_HANDLE){
			KillTimer(SpecTimer[client]);
			SpecTimer[client] = INVALID_HANDLE;
		}
	}
	if(SpecHopPunishVal == 2 && PlayerSpec[client])
	{
		SetPlayerCash(client,GetConVarInt(cvarSetMoneyValue));
		PlayerSpec[client] = false;
		if(SpecTimer[client] != INVALID_HANDLE){
			KillTimer(SpecTimer[client]);
			SpecTimer[client] = INVALID_HANDLE;
		}
	}
}

public OnMapEnd(){
	for(new i = 0; i < MAXPLAYERS + 1; i++){
		FirstJoined[i] = true;
		PlayerSpec[i] = false;
		if(SpecTimer[i] != INVALID_HANDLE){
			KillTimer(SpecTimer[i]);
			SpecTimer[i] = INVALID_HANDLE;
		}
		
	}
}

public OnMapStart()
{
	for(new i = 0; i < MAXPLAYERS + 1; i++){
		FirstJoined[i] = true;
		PlayerSpec[i] = false;
		if(SpecTimer[i] != INVALID_HANDLE){
			KillTimer(SpecTimer[i]);
			SpecTimer[i] = INVALID_HANDLE;
		}
	}
}

public OnClientAuthorized(client,const String:auth[]){
	FirstJoined[client] = true;
	PlayerSpec[client] = false;
	if(SpecTimer[client] != INVALID_HANDLE){
			KillTimer(SpecTimer[client]);
			SpecTimer[client] = INVALID_HANDLE;
	}
}

public GetPlayerCash(entity)
{
	return GetEntData(entity, g_MoneyOffset);
}

public SetPlayerCash(entity, amount)
{
	SetEntData(entity, g_MoneyOffset, amount, 4, true);
}