/*
 *descriptions here
 */

new const String:PLUGIN_VERSION[60] = "1.5.6.26";

public Plugin:myinfo = {
	
	name = "RealisticReload",
	author = "javalia",
	description = "remove remaining bullets on magazine when reload for realistic reload",
	version = PLUGIN_VERSION,
	url = "http://www.sourcemod.net/"
	
};

//uncomment if u wanna use function of these include file
#include <sourcemod>
#include <sdktools>
#include <cstrike>
#include "sdkhooks"

//semicolon!!!!
#pragma semicolon 1

enum guntype{
	
	GUNTYPE_NONE = 0,//not a gun!
	GUNTYPE_SHOTGUN,//i want to make this gun also able to reload additional bullets while its having bullets in chamber...
	GUNTYPE_CLOSEDBOLT,//these guns can have bullet in chamber while reloading
	GUNTYPE_CLOSEDBOLT_DUAL,//for dual beretta
	GUNTYPE_OPENBOLT//these guns cannot have any bullet in chamber while reloading

}

enum gunstatus{

	GUNSTATUS_NONE = 0,//no status?
	GUNSTATUS_RELOAD,
	GUNSTATUS_RELOADWITHCHAMBERBULLET,
	GUNSTATUS_RELOADWITHCHAMBERBULLET2//for duel beretta 

}

new guntype:g_guntype[2048];
new gunstatus:g_gunstatus[2048];

new bool:g_bfreezetime = false;

public OnPluginStart(){

	CreateConVar("RealisticReload_version", PLUGIN_VERSION, "plugin info cvar", FCVAR_NOTIFY | FCVAR_DONTRECORD);
	
	HookEvent("round_end", EventRoundEnd);
	HookEvent("round_freeze_end", EventRoundFreezeEnd);
	
}

public OnEntityCreated(entity, const String:classname[]){
	
	if(entity >= 0 && entity <= 2047){
	
		g_gunstatus[entity] = GUNSTATUS_NONE;
		
		if(StrEqual(classname, "weapon_m3", false) || StrEqual(classname, "weapon_xm1014", false)){
			
			g_guntype[entity] = GUNTYPE_SHOTGUN;
			
		}else if(StrEqual(classname, "weapon_m249", false) || StrEqual(classname, "weapon_mac10", false)){
		
			g_guntype[entity] = GUNTYPE_OPENBOLT;
			
		}else if(StrEqual(classname, "weapon_elite", false)){
		
			g_guntype[entity] = GUNTYPE_CLOSEDBOLT_DUAL;
		
		}else if(StrContains(classname, "weapon", false) != -1){
		
			g_guntype[entity] = GUNTYPE_CLOSEDBOLT;
			//this can be looks weird because it sets entity to closed bolt guns, even in case the entity is not even weapon.
			//but it will not make problem.
			
		}
		
	}

}

public Action:EventRoundEnd(Handle:Event, const String:Name[], bool:Broadcast){
	
	for(new client = 1; client <= MaxClients; client++){
		
		if(IsClientInGame(client)){
		
			for(new i = 0; i < 48; i++){
	
				new weapon = GetEntPropEnt(client, Prop_Data, "m_hMyWeapons", i);
				
				if(weapon != -1){
					
					g_gunstatus[weapon] = GUNSTATUS_NONE;
				
				}
	
			}
		
		}
	
	}
	
	g_bfreezetime = true;

}

public Action:EventRoundFreezeEnd(Handle:Event, const String:Name[], bool:Broadcast){

	g_bfreezetime = false;

}

public OnClientPutInServer(client){
	
	if(!IsFakeClient(client)){
	
		SDKHook(client, SDKHook_PreThink, PreThinkHook);
		//bots doesnt need any handling about this
		//if we try to handle this, bots will do unexpected reload on freezetime.
		
	}
	SDKHook(client, SDKHook_PostThink, PostThinkHook);

}

public PreThinkHook(client){
	
	new buttons = GetEntProp(client, Prop_Data, "m_nButtons");
	
	if(IsPlayerAlive(client)){
			
		if(buttons & IN_RELOAD && ~buttons & IN_ATTACK && !g_bfreezetime){
			
			new weapon = GetEntPropEnt(client, Prop_Data, "m_hActiveWeapon");
			
			if(weapon != -1 && g_gunstatus[weapon] == GUNSTATUS_NONE
				&& GetEntPropFloat(weapon, Prop_Data, "m_flNextPrimaryAttack") <= GetGameTime()
				&& GetEntPropFloat(client, Prop_Data, "m_flNextAttack") <= GetGameTime()
				&& !GetEntProp(weapon, Prop_Data, "m_bInReload")){
				
				new ammotype = GetEntProp(weapon, Prop_Data, "m_iPrimaryAmmoType");
				
				if(ammotype != -1){
				
					new reservedammo = GetEntProp(client, Prop_Data, "m_iAmmo", 4, ammotype);
					
					if(reservedammo >= 1){
						
						if(g_guntype[weapon] == GUNTYPE_CLOSEDBOLT){
							
							if(GetEntProp(weapon, Prop_Data, "m_iClip1") > 1){
							
								SetEntProp(weapon, Prop_Data, "m_iClip1", 1);//lets make our gun to reload.
								
							}
							
						}else if(g_guntype[weapon] == GUNTYPE_CLOSEDBOLT_DUAL){
							
							if(GetEntProp(weapon, Prop_Data, "m_iClip1") > 2){
							
								SetEntProp(weapon, Prop_Data, "m_iClip1", 2);//lets make our gun to reload.
							
							}
							
						}else if(g_guntype[weapon] == GUNTYPE_OPENBOLT){
						
							SetEntProp(weapon, Prop_Data, "m_iClip1", 0);//lets make our gun to reload.
							
						}
						
					}
					
				}
				
			}
			
		}

	}

}

public PostThinkHook(client){
	
	if(IsPlayerAlive(client)){
	
		new weapon = GetEntPropEnt(client, Prop_Data, "m_hActiveWeapon");
		
		if(weapon != -1){
			
			new ammo = GetEntProp(weapon, Prop_Data, "m_iClip1");
			
			if(GetEntProp(weapon, Prop_Data, "m_bInReload") && !g_bfreezetime){
			
				if(g_guntype[weapon] == GUNTYPE_CLOSEDBOLT){
					
					if(ammo >= 1){
					
						SetEntProp(weapon, Prop_Data, "m_iClip1", 1);
						g_gunstatus[weapon] = GUNSTATUS_RELOADWITHCHAMBERBULLET;
					
					}else{
					
						g_gunstatus[weapon] = GUNSTATUS_RELOAD;
					
					}
					
				}else if(g_guntype[weapon] == GUNTYPE_CLOSEDBOLT_DUAL){
					
					if(ammo >= 2){
					
						SetEntProp(weapon, Prop_Data, "m_iClip1", 2);
						g_gunstatus[weapon] = GUNSTATUS_RELOADWITHCHAMBERBULLET2;
					
					}else if(ammo == 1){
					
						g_gunstatus[weapon] = GUNSTATUS_RELOADWITHCHAMBERBULLET;
					
					}else{
					
						g_gunstatus[weapon] = GUNSTATUS_RELOAD;
					
					}
					
				}else if(g_guntype[weapon] == GUNTYPE_OPENBOLT){
				
					SetEntProp(weapon, Prop_Data, "m_iClip1", 0);
					g_gunstatus[weapon] = GUNSTATUS_RELOAD;
				
				}
			
			}else if(g_gunstatus[weapon] == GUNSTATUS_RELOADWITHCHAMBERBULLET){
				
				if(ammo > 1){
				
					//bullet has increased. it means reload has fully finished.
					new ammotype = GetEntProp(weapon, Prop_Data, "m_iPrimaryAmmoType");
					new reservedammo = GetEntProp(client, Prop_Data, "m_iAmmo", 4, ammotype);
					
					if(reservedammo >= 1){
					
						SetEntProp(weapon, Prop_Data, "m_iClip1", GetEntProp(weapon, Prop_Data, "m_iClip1") + 1);
						SetEntProp(client, Prop_Data, "m_iAmmo", reservedammo - 1, 4, ammotype);
						
					}
					
					g_gunstatus[weapon] = GUNSTATUS_NONE;
					
				}
				
			}else if(g_gunstatus[weapon] == GUNSTATUS_RELOADWITHCHAMBERBULLET2){
			
				//bullet has increased. it means reload has fully finished.
				new ammotype = GetEntProp(weapon, Prop_Data, "m_iPrimaryAmmoType");
				new reservedammo = GetEntProp(client, Prop_Data, "m_iAmmo", 4, ammotype);
				
				if(reservedammo >= 2){
				
					SetEntProp(weapon, Prop_Data, "m_iClip1", GetEntProp(weapon, Prop_Data, "m_iClip1") + 2);
					SetEntProp(client, Prop_Data, "m_iAmmo", reservedammo - 2, 4, ammotype);
					
				}else if(reservedammo == 1){
				
					SetEntProp(weapon, Prop_Data, "m_iClip1", GetEntProp(weapon, Prop_Data, "m_iClip1") + 1);
					SetEntProp(client, Prop_Data, "m_iAmmo", reservedammo - 1, 4, ammotype);
				
				}
				
				g_gunstatus[weapon] = GUNSTATUS_NONE;
			
			}else if(g_gunstatus[weapon] == GUNSTATUS_RELOAD){
			
				g_gunstatus[weapon] = GUNSTATUS_NONE;
			
			}
		
		}
		
	}

}