#include "cPMod/globals.sp"

public Action:Event_player_spawn(Handle:event, const String:name[], bool:dontBroadcast){
	new client = GetClientOfUserId(GetEventInt(event, "userid"));
	if(g_Noblock){
		SetEntData(client, FindSendPropOffs("CBaseEntity", "m_CollisionGroup"), 2, 4, true);
		blocking[client] = false;
	}
	if(g_Alpha){
		SetEntityRenderMode(client, RENDER_TRANSCOLOR);
		SetEntityRenderColor(client, 255,255,255,70);
	}
	if(g_AutoFlash)
		GivePlayerItem(client, "weapon_flashbang");
    
	if(g_HealClient)
		SetEntData(client, FindSendPropOffs("CBasePlayer", "m_iHealth"), 500);
	
	if(g_Timer)
		MapTimer[client] = CreateTimer(1.0, RoundTimer, client, TIMER_REPEAT);
		
	if(GetUserAdmin(client) != INVALID_ADMIN_ID){
		if(g_Tracer)
			TracerTimer[client] = CreateTimer(1.0, TraceTimer, client, TIMER_REPEAT);

		if(g_Timer && !g_CordsSet){
			CpAdminPanel(client);
			PrintToChat(client, "%t", "CordsNotSet", YELLOW,LIGHTGREEN,YELLOW,GREEN,YELLOW);
		}
	}
}
public Action:Event_player_hurt(Handle:event, const String:name[], bool:dontBroadcast){
	new client = GetClientOfUserId(GetEventInt(event, "userid"));
	new damage = GetEventInt(event, "damage");
	SetEntData(client, FindSendPropOffs("CBasePlayer", "m_iHealth"), 500+damage);
} 
public Action:Event_player_jump(Handle:event,const String:name[],bool:dontBroadcast){
	new client = GetClientOfUserId(GetEventInt(event, "userid"));
	jumps[client]++;
}

public Action:TraceTimer(Handle:timer, any:client){
	if(client != 0 && IsClientInGame(client) && IsPlayerAlive(client)){
		TE_SetupBeamFollow(client,BeamSpriteFollow,0,1.0,5.0,50.0,70,{255,255,255,100});TE_SendToAll();
		return Plugin_Continue;
	}else
		return Plugin_Stop;
}

public IsInsideBox(Float: pcords[3], pos){
	new Float:px=pcords[0];
	new Float:py=pcords[1];
	new Float:pz=pcords[2];
	
	decl Float:bsx;
	decl Float:bsy;
	decl Float:bsz;
	decl Float:bex;
	decl Float:bey;
	decl Float:bez;
	
	if(pos == 0){
		bsx=maptimer_beginstart_cords[0];
		bsy=maptimer_beginstart_cords[1];
		bsz=maptimer_beginstart_cords[2];
		bex=maptimer_beginstop_cords[0];
		bey=maptimer_beginstop_cords[1];
		bez=maptimer_beginstop_cords[2];
	}else{
		bsx=maptimer_endstart_cords[0];
		bsy=maptimer_endstart_cords[1];
		bsz=maptimer_endstart_cords[2];
		bex=maptimer_endstop_cords[0];
		bey=maptimer_endstop_cords[1];
		bez=maptimer_endstop_cords[2];
	}
	
	new bool:x=false;
	new bool:y=false;
	new bool:z=false;
	
	if(bsx>bex && px<=bsx && px>=bex)
		x=true;
	if(bsy>bey && py<=bsy && py>=bey)
		y=true;
	if(bsz>bez && pz <= bsz && pz>=bez)
		z=true;
	
	if(bsx<bex && px>=bsx && px<=bex)
		x=true;
	if(bsy<bey && py>=bsy && py<=bey)
		y=true;
	if(bsz<bez && pz>=bsz && pz<=bez)
		z=true;
	
	if(x&&y&&z)
		return true;

	return false;	
}


public Action:RoundTimer(Handle:timer, any:client){
	if(client != 0 && IsClientInGame(client) && IsPlayerAlive(client)){
		decl Float:pcords[3];
		GetClientAbsOrigin(client,pcords);
		
		if(racing[client] == false){
			if(IsInsideBox(pcords, 0)){
				racing[client] = true;
				runtime[client] = 0;
				jumps[client] = 0;
				PrintToChat(client, "%t", "TimerStarted", YELLOW,LIGHTGREEN,YELLOW,GREEN,YELLOW);
			}
		}else{
			if(IsInsideBox(pcords, 0)){
				runtime[client] = 0;
				jumps[client] = 0;
				PrintToChat(client, "%t", "TimerRestarted", YELLOW,LIGHTGREEN,YELLOW,GREEN,YELLOW);
			} else {
				decl String:time[32];
				new minutes = runtime[client]/60;
				new seconds = runtime[client]%60;
				Format(time, 32, "%im %is", minutes, seconds);
				decl Float:velocity[3];
				GetEntPropVector(client, Prop_Data, "m_vecVelocity", velocity);
		
				new speed = RoundToFloor(SquareRoot(Pow(velocity[0],2.0)+Pow(velocity[1],2.0)+Pow(velocity[2],2.0))*0.06858);
		
				PrintHintText(client,"Your time: %s\nJumps: %i\nSpeed: %i km/h",time,jumps[client],speed);
				if(g_HintSound == false)
					StopSound(client, SNDCHAN_STATIC, "UI/hint.wav");
				
				runtime[client]++;

				if(IsInsideBox(pcords, 1)){
					if(runtime[client] < recordtime){
						decl String:query[255];
						decl String:username[MAX_NAME_LENGTH];
						decl String:safe_uname[MAX_NAME_LENGTH];
						GetClientName(client, username, MAX_NAME_LENGTH);
						SQL_EscapeString(db, username, safe_uname, MAX_NAME_LENGTH);
						Format(query, 255, sql_updatetimer, safe_uname , jumps[client], runtime[client], mapname);
						SQL_TQuery(db, SQL_CheckCallback, query);
					
						recordname = username;
						recordjumps = jumps[client];
						recordtime = runtime[client];
					
						PrintToChatAll( "%t", "TimerRecord", YELLOW,LIGHTGREEN,YELLOW,GREEN,YELLOW,GREEN,YELLOW);
						EmitSoundToAll(recordSound,client);
					}else{
						PrintToChat(client, "%t", "TimerFinished", YELLOW,LIGHTGREEN,YELLOW,GREEN,YELLOW,GREEN,YELLOW);
					}
					racing[client] = false;
					return Plugin_Stop;
				}
			}
			return Plugin_Continue;
		}
	} else {
		racing[client] = false;
		return Plugin_Stop;
	}
	return Plugin_Continue;
}

public Action:Event_flashbang_detonate(Handle:event,const String:name[],bool:dontBroadcast){
	new client = GetClientOfUserId(GetEventInt(event,"userid"));
	SetEntDataFloat(client,FindSendPropOffs("CCSPlayer", "m_flFlashMaxAlpha"),0.0);
}
public Action:Event_weapon_fire(Handle:event,const String:name[],bool:dontBroadcast){
	decl String:weaponname[32];
	GetEventString(event, "weapon", weaponname, 200);
	new client = GetClientOfUserId(GetEventInt(event,"userid"));
	if(StrEqual(weaponname,"flashbang"))
		GivePlayerItem(client, "weapon_flashbang");
}

public Action:Command_Say(client, args){
	if(client != 0 && IsClientInGame(client) && IsPlayerAlive(client)){
		decl String:text[192];
		GetCmdArgString(text, 192);
		new startidx = 0;
		
		if(text[strlen(text)-1] == '"'){
			text[strlen(text)-1] = '\0';
			startidx = 1;
		}
		if(StrEqual(text[startidx], "!wr"))
			RecordPanel(client);
		if(StrEqual(text[startidx], "!stop"))
			StopTimer(client);
		if(StrEqual(text[startidx], "!restart"))
			RestartTimer(client);
		if(StrEqual(text[startidx], "!block"))
			ToogleBlock(client);
		if(StrEqual(text[startidx], "!scout"))
			ScoutClient(client);
		if(StrEqual(text[startidx], "!lowgrav"))
			ClientGravity(client,0.5);
		if(StrEqual(text[startidx], "!normalgrav"))
			ClientGravity(client,1.0);
		
		if(g_Enabled){
			if(StrEqual(text[startidx], "!next"))
				TeleClient(client,1);
			if(StrEqual(text[startidx], "!prev"))
				TeleClient(client,-1);
			if(StrEqual(text[startidx], "!save"))
				SaveClientLocation(client);
			if(StrEqual(text[startidx], "!tele"))
				TeleClient(client,0);
			if(StrEqual(text[startidx], "!cpadmin"))
				CpAdminPanel(client); 
			if(StrEqual(text[startidx], "!cp"))
				TeleMenu(client);
			if(StrEqual(text[startidx], "!clear"))
				ClearClient(client);
			if(StrEqual(text[startidx], "!help"))
				HelpPanel(client);
		}
		return Plugin_Continue;
	}
	return Plugin_Continue;
}
