#include "cPMod/globals.sp"

public RecordPanel(client){
	new String:vrname[MAX_NAME_LENGTH];
	new String:vrjumps[64];
	new String:vrtime[64];
	Format(vrname, MAX_NAME_LENGTH, "User: %s", recordname);
	Format(vrjumps, 64, "Jumps: %i", recordjumps);  
	Format(vrtime, 64, "Time: %im %is", recordtime/60, recordtime%60);
	
	new Handle:panel = CreatePanel();
	DrawPanelText(panel, "byaaaaah's [cP Mod]");
	DrawPanelText(panel, " ");
	DrawPanelText(panel, vrname);
	DrawPanelText(panel, vrjumps);
	DrawPanelText(panel, vrtime);
	DrawPanelItem(panel, "exit");
	SendPanelToClient(panel, client, RecordPanelHandler, 10);
	CloseHandle(panel);
}
public RecordPanelHandler(Handle:menu, MenuAction:action, param1, param2){
}

public StopTimer(client){
	racing[client] = false;
	CloseHandle(MapTimer[client]);
	PrintToChat(client, "%t", "TimerStopped", YELLOW,LIGHTGREEN,YELLOW,GREEN,YELLOW,GREEN,YELLOW);
}

public RestartTimer(client){
	racing[client] = false;
	ForcePlayerSuicide(client);
	MapTimer[client] = CreateTimer(1.0, RoundTimer, client, TIMER_REPEAT);
}

public ToogleBlock(client){    
	if(GetClientTeam(client) != 0 && g_Noblock && g_PlayerBlock){
		if(blocking[client]){
			SetEntData(client, FindSendPropOffs("CBaseEntity", "m_CollisionGroup"), 2, 4, true);
			blocking[client] = false;
			PrintToChat(client, "%t", "BlockingDisabled", YELLOW,LIGHTGREEN,YELLOW,GREEN,YELLOW);
		}else{
			SetEntData(client, FindSendPropOffs("CBaseEntity", "m_CollisionGroup"), 5, 4, true);
			blocking[client] = true;
			PrintToChat(client, "%t", "BlockingEnabled", YELLOW,LIGHTGREEN,YELLOW,GREEN,YELLOW);
		}
	}else
		PrintToChat(client, "%t", "NoblockDisabled", YELLOW,LIGHTGREEN,YELLOW);
}

public ScoutClient(client){
	new limit = GetConVarInt(cvarScoutLimit);
	if(scouts[client] < limit){
		GivePlayerItem(client, "weapon_scout");
		scouts[client] ++;
		PrintToChat(client, "%t", "ScoutGiven", YELLOW,LIGHTGREEN,YELLOW);
	}else
		PrintToChat(client, "%t", "ScoutLimit", YELLOW,LIGHTGREEN,YELLOW);
}

public ClientGravity(client,Float:amount){
	if(g_Gravity && GetClientTeam(client) != 0){
		SetEntityGravity(client, amount);
		if(amount>=1.0)
			PrintToChat(client, "%t", "GravityNormal", YELLOW,LIGHTGREEN,YELLOW,GREEN,YELLOW);
		else
			PrintToChat(client, "%t", "GravityLow", YELLOW,LIGHTGREEN,YELLOW,GREEN,YELLOW);
	}else
		PrintToChat(client, "%t", "GravityDisabled", YELLOW,LIGHTGREEN,YELLOW);
}

public SaveClientLocation(client){
	if(!racing[client]){
		if(GetEntDataEnt2(client, FindSendPropOffs("CBasePlayer", "m_hGroundEntity")) != -1){
			new current = currentcp[client];
			new whole = wholecp[client];
			   
			new limit = GetConVarInt(cvarCpLimit); 
			if(current < limit){
				GetClientAbsOrigin(client,playercords[client][current+1]);
				GetClientAbsAngles(client,playerangles[client][current+1]);
				currentcp[client] ++;
				current = currentcp[client];   //maybe current = ++currentcp[client];???
				whole = wholecp[client];
				if (current>whole){
					wholecp[client] = current;
					whole = current;
				}
				PrintToChat(client, "%t", "CpSaved", YELLOW,LIGHTGREEN,YELLOW,GREEN,current,whole,YELLOW);
			
				EmitSoundToClient(client,"buttons/blip1.wav",client);
				TE_SetupBeamRingPoint(playercords[client][current],10.0,200.0,BeamSpriteRing1,0,0,10,1.0,50.0,0.0,{255,255,255,255},0,0);
				TE_SendToClient(client);
			}else
				PrintToChat(client, "%t", "CpLimit", YELLOW,LIGHTGREEN,YELLOW,GREEN,YELLOW);
		}else
			PrintToChat(client, "%t", "NotOnGround", YELLOW,LIGHTGREEN,YELLOW);
	}else
		PrintToChat(client, "%t", "TimerActiveProtection", YELLOW,LIGHTGREEN,YELLOW,GREEN,YELLOW);
}

public TeleClient(client,pos){
	if(!racing[client]){
		new current = currentcp[client];
		new whole = wholecp[client];
			  
		if(current == whole && pos == 1){
			currentcp[client] = 0;
			current = 0;
		}
		if(current == 1  && pos == -1){
			currentcp[client] = whole+1;
			current = whole+1;
		}
			  
		new actual = current+pos;
			
		if((actual>GetConVarInt(cvarCpLimit)) || (actual<1) || (playercords[client][actual][0] == 0) && (playercords[client][actual][1] == 0) && (playercords[client][actual][2] == 0)){
			PrintToChat(client, "%t", "CpNotFound", YELLOW,LIGHTGREEN,YELLOW);
		}else{
			TeleportEntity(client, playercords[client][actual],playerangles[client][actual],NULL_VECTOR);
			PrintToChat(client, "%t", "CpTeleported", YELLOW,LIGHTGREEN,YELLOW,GREEN,actual,whole,YELLOW);
			currentcp[client] += pos;
			
			EmitSoundToClient(client,"buttons/blip1.wav",client);
			TE_SetupBeamRingPoint(playercords[client][actual],10.0,200.0,BeamSpriteRing2,0,0,10,1.0,50.0,0.0,{255,255,255,255},0,0);
			TE_SendToClient(client);
		}
	}else
		PrintToChat(client, "%t", "TimerActiveProtection", YELLOW,LIGHTGREEN,YELLOW,GREEN,YELLOW);
}

public TeleMenu(client){
	new Handle:menu = CreateMenu(TeleMenuHandler);
	SetMenuTitle(menu, "byaaaaah's [cP Mod]");
	AddMenuItem(menu, "!save", "Saves a location");
	AddMenuItem(menu, "!tele", "Teleports you to last checkpoint");
	AddMenuItem(menu, "!next", "Next checkpoint");
	AddMenuItem(menu, "!prev", "Previous checkpoint");
	AddMenuItem(menu, "!clear", "Erase all checkpoints");
	SetMenuExitButton(menu, true);
	SetMenuOptionFlags(menu, MENUFLAG_BUTTON_EXIT);
	DisplayMenu(menu, client, MENU_TIME_FOREVER);
}
public TeleMenuHandler(Handle:menu, MenuAction:action, param1, param2){
	if(action == MenuAction_Select){
		switch(param2){
			case 0: SaveClientLocation(param1);
			case 1: TeleClient(param1,0);
			case 2: TeleClient(param1,1);
			case 3: TeleClient(param1,-1);
			case 4: ClearClient(param1);
		}
		TeleMenu(param1);
	}else if(action == MenuAction_End)
	CloseHandle(menu);
}

public ClearClient(client){
	currentcp[client] = 0;
	wholecp[client] = 0;
    
	new limit = GetConVarInt(cvarCpLimit);
	for(new i = 0; i <= limit; i++){
		playercords[client][i][0]=0.0;
		playercords[client][i][1]=0.0;
		playercords[client][i][2]=0.0;
		playerangles[client][i][0]=0.0;
		playerangles[client][i][1]=0.0;
		playerangles[client][i][2]=0.0;
	}
	PrintToChat(client, "%t", "Cleared", YELLOW,LIGHTGREEN,YELLOW);
}

public HelpPanel(client){
	new Handle:panel = CreatePanel();
	DrawPanelText(panel, "byaaaaah's [cP Mod]");
	DrawPanelText(panel, " ");
	DrawPanelText(panel, "!help - Displays this menu");
	DrawPanelText(panel, "!cp - Opens teleportmenu");
	DrawPanelText(panel, " ");
	DrawPanelText(panel, "!save - Saves a checkpoint");
	DrawPanelText(panel, "!tele - Teleports you to last checkpoint");
	DrawPanelText(panel, "!prev - Previous checkpoint");
	DrawPanelText(panel, "!next - Next checkpoint");
	DrawPanelText(panel, "!clear - Erase all checkpoints");
	DrawPanelText(panel, " ");
	DrawPanelText(panel, "!wr - Displays the record of this map");
	DrawPanelText(panel, "!stop - Stops the timer");
	DrawPanelText(panel, "!restart - Restarts your timer");
	DrawPanelText(panel, "!block - Toogles your blocking");
	DrawPanelText(panel, "!scout - Gives you a scout");
	DrawPanelText(panel, "!lowgrav - Lowers your gravity");
	DrawPanelText(panel, "!normalgrav - Normals your gravity");
	DrawPanelItem(panel, "exit");
	SendPanelToClient(panel, client, HelpPanelHandler, 10);
	CloseHandle(panel);
}
public HelpPanelHandler(Handle:menu, MenuAction:action, param1, param2){
}
