#include "cPMod/globals.sp"

public CpAdminPanel(client){
	if(GetUserAdmin(client) != INVALID_ADMIN_ID){
		new Handle:menu = CreateMenu(CpAdminPanelHandler);
		SetMenuTitle(menu, "byaaaaah's [cP Mod] Maptimer");
		AddMenuItem(menu, "Set start area", "Set timer startpoint");
		AddMenuItem(menu, "Set end area", "Set timer endpoint");
		SetMenuExitButton(menu, true);
		SetMenuOptionFlags(menu, MENUFLAG_BUTTON_EXIT);
		DisplayMenu(menu, client, MENU_TIME_FOREVER);
	}else
		PrintToChat(client, "%t", "NotAuthorized", YELLOW,LIGHTGREEN,YELLOW);
}
public CpAdminPanelHandler(Handle:menu, MenuAction:action, param1, param2){
	if(action == MenuAction_Select){
		switch(param2){
			case 0: CpAdminPanelStart(param1);
			case 1: CpAdminPanelEnd(param1);
		}
	}else if(action == MenuAction_End)
	CloseHandle(menu);
}

public CpAdminPanelStart(client){
	new Handle:menu = CreateMenu(CpAdminPanelStartHandler);
	SetMenuTitle(menu, "byaaaaah's [cP Mod] Startarea");
	AddMenuItem(menu, "Begin point", "Begins drawing startpoint");
	AddMenuItem(menu, "Finish point", "Stops drawing startpoint");
	SetMenuExitButton(menu, true);
	SetMenuOptionFlags(menu, MENUFLAG_BUTTON_EXIT);
	DisplayMenu(menu, client, MENU_TIME_FOREVER);
}
public CpAdminPanelStartHandler(Handle:menu, MenuAction:action, param1, param2){
	if(action == MenuAction_Select){
		if(param2 == 0){
			GetClientAbsOrigin(param1,cpsetbcords);
			CpSetterTimer = CreateTimer(0.1, CpSetTimer, param1, TIMER_REPEAT);
			CpAdminPanelStart(param1);
		}else{
			SetTimerCords(param1,0);
			CpAdminPanel(param1);
		}
	}else if(action == MenuAction_End)
	CloseHandle(menu);
}

public CpAdminPanelEnd(client){
	new Handle:menu = CreateMenu(CpAdminPanelEndHandler);
	SetMenuTitle(menu, "byaaaaah's [cP Mod] Stoparea");
	AddMenuItem(menu, "Begin point", "Begins drawing endpoint");
	AddMenuItem(menu, "Finish point", "Stops drawing endpoint");
	SetMenuExitButton(menu, true);
	SetMenuOptionFlags(menu, MENUFLAG_BUTTON_EXIT);
	DisplayMenu(menu, client, MENU_TIME_FOREVER);
}
public CpAdminPanelEndHandler(Handle:menu, MenuAction:action, param1, param2){
	if(action == MenuAction_Select){
		if(param2 == 0){
			GetClientAbsOrigin(param1,cpsetbcords);
			CpSetterTimer = CreateTimer(0.1, CpSetTimer, param1, TIMER_REPEAT);
			CpAdminPanelEnd(param1);
		}else{
			SetTimerCords(param1,1);
			CpAdminPanel(param1);
		}
	}else if(action == MenuAction_End)
	CloseHandle(menu);
}


public Action:CpSetTimer(Handle:timer, any:client){
	if(client != 0 && IsPlayerAlive(client) && IsClientInGame(client)){
		GetClientAbsOrigin(client,cpsetecords);
		
		decl Float:leftbottomfront[3];
		leftbottomfront[0] = cpsetbcords[0];
		leftbottomfront[1] = cpsetbcords[1];
		leftbottomfront[2] = cpsetecords[2];
		decl Float:rightbottomfront[3];
		rightbottomfront[0] = cpsetecords[0];
		rightbottomfront[1] = cpsetbcords[1];
		rightbottomfront[2] = cpsetecords[2];
		
		decl Float:leftbottomback[3];
		leftbottomback[0] = cpsetbcords[0];
		leftbottomback[1] = cpsetecords[1];
		leftbottomback[2] = cpsetecords[2];
		decl Float:rightbottomback[3];
		rightbottomback[0] = cpsetecords[0];
		rightbottomback[1] = cpsetecords[1];
		rightbottomback[2] = cpsetecords[2];
		
		
		decl Float:lefttopfront[3];
		lefttopfront[0] = cpsetbcords[0];
		lefttopfront[1] = cpsetbcords[1];
		lefttopfront[2] = cpsetbcords[2]+100;
		decl Float:righttopfront[3];
		righttopfront[0] = cpsetecords[0];
		righttopfront[1] = cpsetbcords[1];
		righttopfront[2] = cpsetbcords[2]+100;
		
		decl Float:lefttopback[3];
		lefttopback[0] = cpsetbcords[0];
		lefttopback[1] = cpsetecords[1];
		lefttopback[2] = cpsetbcords[2]+100;
		decl Float:righttopback[3];
		righttopback[0] = cpsetecords[0];
		righttopback[1] = cpsetecords[1];
		righttopback[2] = cpsetbcords[2]+100;
		

		TE_SetupBeamPoints(leftbottomfront,rightbottomfront,BeamSpriteFollow,0,0,0,0.1,3.0,3.0,10,0.0,{0,255,0,255},0);TE_SendToAll();
		TE_SetupBeamPoints(leftbottomfront,leftbottomback,BeamSpriteFollow,0,0,0,0.1,3.0,3.0,10,0.0,{0,255,0,255},0);TE_SendToAll();
		TE_SetupBeamPoints(leftbottomfront,lefttopfront,BeamSpriteFollow,0,0,0,0.1,3.0,3.0,10,0.0,{0,255,0,255},0);TE_SendToAll();
		
		TE_SetupBeamPoints(lefttopfront,righttopfront,BeamSpriteFollow,0,0,0,0.1,3.0,3.0,10,0.0,{0,255,0,255},0);TE_SendToAll();
		TE_SetupBeamPoints(lefttopfront,lefttopback,BeamSpriteFollow,0,0,0,0.1,3.0,3.0,10,0.0,{0,255,0,255},0);TE_SendToAll();
		TE_SetupBeamPoints(righttopback,lefttopback,BeamSpriteFollow,0,0,0,0.1,3.0,3.0,10,0.0,{0,255,0,255},0);TE_SendToAll();
		TE_SetupBeamPoints(righttopback,righttopfront,BeamSpriteFollow,0,0,0,0.1,3.0,3.0,10,0.0,{0,255,0,255},0);TE_SendToAll();
		
		TE_SetupBeamPoints(rightbottomback,leftbottomback,BeamSpriteFollow,0,0,0,0.1,3.0,3.0,10,0.0,{0,255,0,255},0);TE_SendToAll();
		TE_SetupBeamPoints(rightbottomback,rightbottomfront,BeamSpriteFollow,0,0,0,0.1,3.0,3.0,10,0.0,{0,255,0,255},0);TE_SendToAll();
		TE_SetupBeamPoints(rightbottomback,righttopback,BeamSpriteFollow,0,0,0,0.1,3.0,3.0,10,0.0,{0,255,0,255},0);TE_SendToAll();
		
		TE_SetupBeamPoints(rightbottomfront,righttopfront,BeamSpriteFollow,0,0,0,0.1,3.0,3.0,10,0.0,{0,255,0,255},0);TE_SendToAll();
		TE_SetupBeamPoints(leftbottomback,lefttopback,BeamSpriteFollow,0,0,0,0.1,3.0,3.0,10,0.0,{0,255,0,255},0);TE_SendToAll();
	}else
		CloseHandle(CpSetterTimer);
}

public SetTimerCords(client,pos){
	decl String:query[255];
	decl String:bcords[255];
	decl String:ecords[255];
	
	Format(bcords, 255, "%f:%f:%f",cpsetbcords[0],cpsetbcords[1],cpsetbcords[2]-50);
	Format(ecords, 255, "%f:%f:%f",cpsetecords[0],cpsetecords[1],cpsetecords[2]+50);
	
	if(pos == 0){
		Format(query, 255, sql_insertbegincords, bcords, ecords, mapname);
		PrintToChat(client, "%t", "StartSet", YELLOW,LIGHTGREEN,YELLOW);
		CloseHandle(CpSetterTimer);
	}else{
		Format(query, 255, sql_insertendcords, bcords, ecords, mapname);
		PrintToChat(client, "%t", "EndSet", YELLOW,LIGHTGREEN,YELLOW);
		CloseHandle(CpSetterTimer);
	}
	SQL_TQuery(db, SQL_CheckCallback, query);

	EmitSoundToClient(client,"buttons/blip1.wav",client);
}

public Action:Admin_ResetCp(client, args){
	if(db == INVALID_HANDLE){
		LogError("[cP Mod] Error: Invalid database handle");
		return Plugin_Continue;
	}
	SQL_LockDatabase(db);
	SQL_FastQuery(db, sql_resetcp);
	SQL_UnlockDatabase(db);
  
	PrintToConsole(client, "CpDatabase cleared. Please restart the server!");
	LogMessage("CpDatabase cleared.");
	return Plugin_Handled;
}
public Action:Admin_PurgeCp(client, args){
	if(db == INVALID_HANDLE){
		LogError("[cP Mod] Error: Invalid database handle");
		return Plugin_Continue;
	}
	decl String:query[255];
	decl String:szdays[64];
	GetCmdArg(1, szdays, 64);
	new days = StringToInt(szdays);
	
	Format(query, 255, sql_purgecp, days);
	SQL_LockDatabase(db);
	SQL_FastQuery(db, query);
	SQL_UnlockDatabase(db);
	
	PrintToConsole(client, "CpDatabase purged.");
	LogMessage("CpDatabase purged.");
	return Plugin_Handled;
}

public Action:Admin_ResetTimer(client, args){
	if(db == INVALID_HANDLE){
		LogError("[cP Mod] Error: Invalid database handle");
		return Plugin_Continue;
	}
	SQL_LockDatabase(db);
	SQL_FastQuery(db, sql_resettimer);
	SQL_UnlockDatabase(db);
	
	PrintToConsole(client, "TimerDatabase cleared. Please restart the server!");
	LogMessage("TimerDatabase cleared.");
	return Plugin_Handled;
}