/*
[cP mod]
- version 1.9

This plugin allows users to save their location and teleport later.
It further provides some features for non skilled bHopper like low gravity or a scout.
Noblock, player transparency, spawn health and healing of falldamage are also included.
In the latest release some new feautes for trix maps like anti flash and auto flash giving.
Also a bhop / climb timer was added that saves the best time into a database.
The last active checkpoint will be added to database aswell to avoid timeouts.
Admins can get a special sprite tracing them.

http://www.game-monitor.com/search.php?search=cPMod_version&type=variable

Cmds:
!c - Erase all checkpoints
!cp    - Opens teleportmenu
!s  - Saves a checkpoint
!t  - Teleports you to last checkpoint
!p  - Previous checkpoint
!n  - Next checkpoint

!wr         - Displays the record on the current map
!stop       - Stops the timer
!block      - Toogles blocking
!scout      - Spawns a scout
!lowgrav    - Sets player gravity to low
!normalgrav - Sets player gravity to default
!help       - Displays the help menu

Cvars:
sm_cp_enabled    - <1|0> Enable/Disable the plugin.
sm_cp_timer      - <1|0> Enable/Disable map based timer.
sm_cp_restore    - <1|0> Enable/Disable automatic saving of checkpoints to database.
sm_cp_cplimit    - <0|10> Sets the cp limit for each player.
sm_cp_noblock    - <1|0> Enable/Disable player blocking.
sm_cp_alpha      - <1|0> Enable/Disable player alpha.
sm_cp_autoflash  - <1|0> Enable/Disable auto flashbang giver.
sm_cp_tracer     - <1|0> Enable/Disable admin tracer.
sm_cp_scoutlimit - <0|10> Sets the scout limit for each player.
sm_cp_gravity    - <1|0> Enable/Disable player gravity.
sm_cp_healclient - <1|0> Enable/Disable healing of falldamage.

Admin:
!cpadmin         - Displays the admin menu
sm_cp_resetcp    - Resets checkpoints of all players.
sm_cp_purgecp    - Purges checkpoints.
sm_cp_resettimer - Resets timers of all players

Versions
1.0
    - Public release
1.1
    - Added angle support for saved checkpoints
    - Added player transparency
    - Added simple NoBlock
    - Fixed minor bugs...
1.2
    - Removed some redundancy
    - Avoided re-indexing of arrays
    - Fixed cvar issues
1.3
    - Added effects on save / teleport
    - Fixed spectator glitch
1.4
    - Translations added
1.5
    - Added !block command
    - Fixed tracer
    - Fixed nodamage
1.6
    - Added Database support
    - Added Timer
    - Added AutoFlashbang
    - Performance increased
1.7
    - Added !stop command
    - Added !restart command
    - Added debuginfo for start/end-coordinates
    - Disabled saving while in the air
    - Fixed !tele glitch on timer running
    - Performance increased
1.8
    - Visualisized coordinate menu
    - Fixed buggy admin tracer
    - Simplyfied code
    - Reorganized whole code
1.9
    - Added playerblock cvar to control !block usage
    - Added restarting timer on entering start area
    - Added control over annoying sound played on popup display
    - Added cvar to specify a sound played on new record
*/


#include <sourcemod>
#include <sdktools>

#include "cPMod/globals.sp"
#include "cPMod/admin.sp"
#include "cPMod/commands.sp"
#include "cPMod/hooks.sp"

public Plugin:myinfo = {
	name = "cPMod",
	author = "byaaaaah",
	description = "Bunnyhop server modification",
	version = VERSION,
	url = "http://b-com.tk"
}

public OnPluginStart(){
	LoadTranslations("cpmod.phrases");
	HookEvent("player_spawn", Event_player_spawn);
	HookEvent("player_jump",Event_player_jump);

	decl String:error[255];
	db = SQL_Connect("storage-local", false, error, 255);
	
	if(db == INVALID_HANDLE){
		LogError("[cP Mod] Unable to connect to database (%s)", error);
		return;
	}
    
	SQL_LockDatabase(db);
	if(SQL_FastQuery(db, sql_createcp) == false){
		LogError("[cP Mod] Could not create table 'checkpoints'...");
		return;
	}
	if(SQL_FastQuery(db, sql_createtimer) == false){
		LogError("[cP Mod] Could not create table 'timer'...");
		return;
	}
	SQL_UnlockDatabase(db);
	
	CreateConVar("cPMod_version", VERSION, "cP Mod version.", FCVAR_DONTRECORD|FCVAR_PLUGIN|FCVAR_SPONLY|FCVAR_REPLICATED|FCVAR_NOTIFY);
	cvarEnable     = CreateConVar("sm_cp_enabled", "1", "Enable/Disable the plugin.", FCVAR_PLUGIN|FCVAR_NOTIFY, true, 0.0, true, 1.0);
	g_Enabled       = GetConVarBool(cvarEnable);
	HookConVarChange(cvarEnable, OnSettingChanged);
	cvarTimer      = CreateConVar("sm_cp_timer", "1", "Enable/Disable map based timer.", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_Timer        = GetConVarBool(cvarTimer);
	HookConVarChange(cvarTimer, OnSettingChanged);
	cvarRestore    = CreateConVar("sm_cp_restore", "1", "Enable/Disable automatic saving of checkpoints to database.", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_Restore      = GetConVarBool(cvarRestore);
	HookConVarChange(cvarRestore, OnSettingChanged);
	cvarCpLimit    = CreateConVar("sm_cp_cplimit", "10", "Sets the cp limit for each player.", FCVAR_PLUGIN, true, 0.0, true, 100.0);
	cvarNoblock    = CreateConVar("sm_cp_noblock", "1", "Enable/Disable player blocking.", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_Noblock      = GetConVarBool(cvarNoblock);
	HookConVarChange(cvarNoblock, OnSettingChanged);

	cvarPlayerBlock = CreateConVar("sm_cp_playerblock", "1", "Enable/Disable player !block command.", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_PlayerBlock = GetConVarBool(cvarPlayerBlock);
	HookConVarChange(cvarPlayerBlock, OnSettingChanged);

	cvarAlpha      = CreateConVar("sm_cp_alpha", "1", "Enable/Disable player alpha.", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_Alpha        = GetConVarBool(cvarAlpha);
	HookConVarChange(cvarAlpha, OnSettingChanged);
	cvarAutoFlash  = CreateConVar("sm_cp_autoflash", "0", "Enable/Disable auto flashbang giver.", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_AutoFlash    = GetConVarBool(cvarAutoFlash);
	HookConVarChange(cvarAutoFlash, OnSettingChanged);
	if(cvarAutoFlash){
		HookEvent("player_blind" , Event_flashbang_detonate);
		HookEvent("weapon_fire" , Event_weapon_fire);
	}
	cvarTracer     = CreateConVar("sm_cp_tracer", "1", "Enable/Disable player Tracers.", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_Tracer       = GetConVarBool(cvarTracer);
	HookConVarChange(cvarTracer, OnSettingChanged);
	cvarScoutLimit = CreateConVar("sm_cp_scoutlimit", "3", "Sets the scout limit for each player." , FCVAR_PLUGIN, true, 0.0, true, 10.0);
	cvarGravity    = CreateConVar("sm_cp_gravity", "1", "Enable/Disable player gravity.", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_Gravity      = GetConVarBool(cvarGravity);
	HookConVarChange(cvarGravity, OnSettingChanged);
	cvarHealClient = CreateConVar("sm_cp_healclient", "1", "Enable/Disable healing of damage.", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_HealClient   = GetConVarBool(cvarHealClient);
	HookConVarChange(cvarHealClient, OnSettingChanged);
	if(cvarHealClient)
		HookEvent("player_hurt", Event_player_hurt);
		
	cvarHintSound = CreateConVar("sm_cp_hintsound", "0", "Enable/Disable playing sound on popup.", FCVAR_PLUGIN, true, 0.0, true, 1.0);
	g_HintSound = GetConVarBool(cvarHintSound);
	HookConVarChange(cvarHintSound, OnSettingChanged);
		
	cvarRecordSound = CreateConVar("sm_cp_recourdsound", "quake/holyshit.wav", "Sets the sound that is played on new record.", FCVAR_PLUGIN);
	GetConVarString(cvarRecordSound, recordSound, 64);
	
	RegConsoleCmd("say", Command_Say);
	RegAdminCmd("sm_cp_resetcp", Admin_ResetCp, ADMFLAG_CONFIG, "Resets checkpoints of all players.");
	RegAdminCmd("sm_cp_purgecp", Admin_PurgeCp, ADMFLAG_CONFIG, "Purges checkpoints of all players.");
	RegAdminCmd("sm_cp_resettimer", Admin_ResetTimer, ADMFLAG_CONFIG, "Resets timers of all players.");

	AutoExecConfig(true, "sm_cpmod");
}

public OnMapStart(){
	BeamSpriteFollow = PrecacheModel("materials/sprites/laserbeam.vmt");
	BeamSpriteRing1 = PrecacheModel("materials/sprites/tp_beam001.vmt");
	BeamSpriteRing2 = PrecacheModel("materials/sprites/crystal_beam1.vmt");
	PrecacheSound("buttons/blip1.wav", true);
	PrecacheSound(recordSound, true);
	AddFileToDownloadsTable(recordSound);
    
	decl String:query[255];
	GetCurrentMap(mapname, 64);
	
	PrintToServer(mapname);
	
	if(g_Enabled){
		for(new i = 0; i <= MAXPLAYERS; i++){
			if(MapTimer[i] != INVALID_HANDLE){
				CloseHandle(MapTimer[i]);
				MapTimer[i] = INVALID_HANDLE;
			}
			if(TracerTimer[i] != INVALID_HANDLE){
				CloseHandle(TracerTimer[i]);
				TracerTimer[i] = INVALID_HANDLE;
			}
			currentcp[i] = 0;
			wholecp[i] = 0;
			scouts[i] = 0;
			runtime[i] = 0;
			jumps[i] = 0;
		}
	}

	Format(query, 255, sql_selecttimer, mapname);
	SQL_TQuery(db, SQL_SelectTimerCallback, query);
}
public SQL_SelectTimerCallback(Handle:owner, Handle:hndl, const String:error[], any:data){
	if(hndl == INVALID_HANDLE)
    LogError("[cP Mod] Error loading checkpoint (%s)", error);

	if(SQL_HasResultSet(hndl) && SQL_FetchRow(hndl)){
		decl String:beginstart_cords[255];
		decl String:beginstop_cords[255];
		decl String:endstart_cords[255];
		decl String:endstop_cords[255];
		
		SQL_FetchString(hndl, 0, beginstart_cords, 255);
		SQL_FetchString(hndl, 1, beginstop_cords, 255);
		SQL_FetchString(hndl, 2, endstart_cords, 255);
		SQL_FetchString(hndl, 3, endstop_cords, 255);
		SQL_FetchString(hndl, 4, recordname, MAX_NAME_LENGTH);
		recordjumps = SQL_FetchInt(hndl, 5);
		recordtime = SQL_FetchInt(hndl, 6);
		
		if(StrEqual(beginstart_cords, "0.000000:0.000000:0.000000") || StrEqual(beginstop_cords, "0.000000:0.000000:0.000000") || StrEqual(endstart_cords, "0.000000:0.000000:0.000000") || StrEqual(endstop_cords, "0.000000:0.000000:0.000000")){
			g_CordsSet = false;
		}else{
			g_CordsSet = true;
			decl String:cbuff[3][255]
			ExplodeString(beginstart_cords, ":", cbuff, 3, 255);
			maptimer_beginstart_cords[0] = StringToFloat(cbuff[0]);
			maptimer_beginstart_cords[1] = StringToFloat(cbuff[1]);
			maptimer_beginstart_cords[2] = StringToFloat(cbuff[2]);
			
			ExplodeString(beginstop_cords, ":", cbuff, 3, 255);
			maptimer_beginstop_cords[0] = StringToFloat(cbuff[0]);
			maptimer_beginstop_cords[1] = StringToFloat(cbuff[1]);
			maptimer_beginstop_cords[2] = StringToFloat(cbuff[2]);
			
			ExplodeString(endstart_cords, ":", cbuff, 3, 255);
			maptimer_endstart_cords[0] = StringToFloat(cbuff[0]);
			maptimer_endstart_cords[1] = StringToFloat(cbuff[1]);
			maptimer_endstart_cords[2] = StringToFloat(cbuff[2]);
			
			ExplodeString(endstop_cords, ":", cbuff, 3, 255);
			maptimer_endstop_cords[0] = StringToFloat(cbuff[0]);
			maptimer_endstop_cords[1] = StringToFloat(cbuff[1]);
			maptimer_endstop_cords[2] = StringToFloat(cbuff[2]);
		}
	}else{
		decl String:query[255];
		Format(query, 255, sql_inserttimer, mapname);		
		SQL_TQuery(db, SQL_CheckCallback, query);
		ServerCommand("changelevel %s",mapname);
  }
}

public OnSettingChanged(Handle:convar, const String:oldValue[], const String:newValue[]){
	if(convar == cvarEnable){
		if(newValue[0] == '1')
			g_Enabled = true;
		else
			g_Enabled = false;
	} else if(convar == cvarTimer){
		if(newValue[0] == '1')
			g_Timer = true;
		else
			g_Timer = false;
	} else if(convar == cvarRestore){
		if(newValue[0] == '1')
			g_Restore = true;
		else
			g_Restore = false;
	} else if(convar == cvarNoblock){
		if(newValue[0] == '1')
			g_Noblock = true;
		else
			g_Noblock = false;
	} else if(convar == cvarPlayerBlock){
		if(newValue[0] == '1')
			g_PlayerBlock = true;
		else
			g_PlayerBlock = false;
	} else if(convar == cvarAlpha){
		if(newValue[0] == '1')
			g_Alpha = true;
		else
			g_Alpha = false;
	} else if(convar == cvarAutoFlash){
		if(newValue[0] == '1'){
			HookEvent("player_blind" , Event_flashbang_detonate);
			HookEvent("weapon_fire" , Event_weapon_fire);
			g_AutoFlash = true;
		}else{
			g_AutoFlash = false;
			UnhookEvent("player_blind" , Event_flashbang_detonate);
			UnhookEvent("weapon_fire" , Event_weapon_fire);
		}
	} else if(convar == cvarTracer){
		if(newValue[0] == '1')
			g_Tracer = true;
		else
		g_Tracer = false;
	}else if(convar == cvarGravity){
		if(newValue[0] == '1')
			g_Gravity = true;
		else
			g_Gravity = false;
	} else if(convar == cvarHealClient){
		if(newValue[0] == '1'){
			HookEvent("player_hurt", Event_player_hurt);
			g_HealClient = true;
		}else{
			g_HealClient = false;
			UnhookEvent("player_hurt", Event_player_hurt, EventHookMode_Post);
		}
	} else if(convar == cvarHintSound){
		if(newValue[0] == '1')
			g_HintSound = true;
		else
			g_HintSound = false;
	}
}

public OnClientPostAdminCheck(client){
	if(g_Enabled && IsClientInGame(client) && !IsFakeClient(client)){
		if(g_Restore && !g_Timer){
			decl String:query[255];
			decl String:steamid[64];
			GetClientAuthString(client, steamid, 64);
			
			Format(query, 255, sql_selectcp, steamid, mapname);
			SQL_TQuery(db, SQL_SelectCpCallback, query, client);
		}
		HelpPanel(client);
	}	
}
public SQL_SelectCpCallback(Handle:owner, Handle:hndl, const String:error[], any:data){
	new client = data;
	if(hndl == INVALID_HANDLE)
		LogError("[cP Mod] Error loading checkpoint (%s)", error);
	
	if(SQL_HasResultSet(hndl) && SQL_FetchRow(hndl) && IsClientInGame(client)){
		decl String:cords[255];
		decl String:angles[255];
		
		SQL_FetchString(hndl, 0, cords, 255);
		SQL_FetchString(hndl, 1, angles, 255);
		
		if(StrEqual(cords, "0.000000:0.000000:0.000000") || StrEqual(angles, "0.000000:0.000000:0.000000")){
			currentcp[client] = 0;
			wholecp[client] = 0;
		}else{
			decl String:cbuff[3][255]
			ExplodeString(cords, ":", cbuff, 3, 255);
			playercords[client][1][0] = StringToFloat(cbuff[0]);
			playercords[client][1][1] = StringToFloat(cbuff[1]);
			playercords[client][1][2] = StringToFloat(cbuff[2]);
			
			ExplodeString(angles, ":", cbuff, 3, 255);
			playerangles[client][1][0] = StringToFloat(cbuff[0]);
			playerangles[client][1][1] = StringToFloat(cbuff[1]);
			playerangles[client][1][2] = StringToFloat(cbuff[2]);
			currentcp[client] = 1;
			wholecp[client] = 1;
			PrintToChat(client, "%t", "CheckpointRestored", YELLOW,LIGHTGREEN,YELLOW,GREEN,YELLOW);
		}
	}else if(IsClientInGame(client)){
		decl String:query[255];
		decl String:steamid[64];
		GetClientAuthString(client, steamid, 64);
		
		Format(query, 255, sql_insertcp, mapname, steamid);
		SQL_TQuery(db, SQL_CheckCallback, query);
	}
}

public OnClientDisconnect(client){
	if(g_Enabled){
		if(g_Tracer && TracerTimer[client] != INVALID_HANDLE){
				CloseHandle(TracerTimer[client]);
				TracerTimer[client] = INVALID_HANDLE;
		}
		if(g_Timer && MapTimer[client] != INVALID_HANDLE){
				CloseHandle(MapTimer[client]);
				MapTimer[client] = INVALID_HANDLE;
		}
		new current = currentcp[client];
		if(g_Restore && current > 0){
			decl String:query[255];
			new timestamp = GetTime();
			decl String:steamid[64];
			GetClientAuthString(client, steamid, 64);
			
			decl String:cords[255];
			Format(cords, 255, "'%f:%f:%f'",playercords[client][current][0],playercords[client][current][1],playercords[client][current][2]);
			decl String:angles[255];
			Format(angles, 255, "'%f:%f:%f'",playerangles[client][current][0],playerangles[client][current][1],playerangles[client][current][2]);
			Format(query, 255, sql_updatecp, cords, angles, timestamp, mapname, steamid);
			SQL_TQuery(db, SQL_CheckCallback, query);
		}
	}
}
public SQL_CheckCallback(Handle:owner, Handle:hndl, const String:error[], any:data){
	if(hndl == INVALID_HANDLE)
		LogError("[cP Mod] Error inserting into database (%s)", error);
}
