#if defined _atac_included_
  #endinput
#endif
#define _atac_included_

public SharedPlugin:__pl_atac = 
{
	name = "atac",
	file = "atac.smx",
#if defined REQUIRE_PLUGIN
	required = 1,
#else
	required = 0,
#endif
};

#define TEAMATTACKS 1
#define TEAMKILLS 2
#define KARMA 3
#define KICKCOUNT 4
#define BANCOUNT 5

functag ATACNatives public();

/**
 * Called when ATAC finishes loading
 *
 * @noreturn
 */
forward OnATACLoaded();

/**
 * Called when ATAC is unloaded
 *
 * @noreturn
 */
forward OnATACUnloaded();

/**
 * Called when ATAC Kicks a player
 * 
 * @param	Player kicked by ATAC
 * 
 * @noreturn
 */
forward OnATACKickClient(param);
 
/**
 * Called when ATAC Bans a player
 * 
 * @param	Player banned by ATAC
 * 
 * @noreturn
 */
forward OnATACBanClient(param);
 
 

/**
 * Gets verbose setting
 *
 * @return	current integer value of "verbose"
 */
native ATACGetVerbose();
  
/**
 * Gets maximum of a value
 *
 * @param	param		Which maximum value to return
						TEAMATTACKS - Team Attacks
						TEAMKILLS - Team Kills
						KARMA - Karma
						KICKCOUNT - Kick count
						BANCOUNT - Ban count
 * @return	maximum of the requested "param"
 			 0 if disabled
 			-1 if failed
 */
native ATACGetMax(param);

/**
 * Gets a client's ATAC value
 *
 * @param	param		Which client value to return
 						TEAMATTACKS - Team attacks
 						TEAMKILLS - Team Kills
 						KARMA - Karma
						KICKCOUNT - Kick count
						BANCOUNT - Ban count
 * @param	index		Client's index
 * @return	Requested current "param" on client
 			-1 if failed
 */
native ATACGetClient(param,index);

/**
 *
 * Sets a client's ATAC value
 *
 * @param	param		Which value to set
 						TEAMATTACKS - Team attacks
 						TEAMKILLS - teamkills
 						KARMA - Karma
 * @param	index		Client's Index
 * @param	value		Value to set on "param"
 * @return	true		if set succeeds
 *				false if set is over the limit and resets or fails to set
 */
native bool:ATACSetClient(param,index,value);

/**
 * Registers a new punishment to add to the menu
 *
 * @param	Forward			Callback for when your punishment is selected.
 * @param	DisplayName		Displayed Option
 * @return	Handle of the registered punishment.
 */
native Handle:RegisterPunishment(const String:Forward[], const String:DisplayName[]);

/**
 * Unregisters previously registered punishment
 *
 * @param	MenuHandle		Handle returned from RegisterPunishment
 * @noreturn
 */
native UnregisterPunishment(Handle:MenuHandle);

/**
 * Gets the punishment delay value
 * Used in conjunction with slay/slap/etc. based plugins in case the "punishee"
 * Is dead at time of menu selection
 *
 * @return	The punishment delay value.
 */
native ATACGetPunishDelay();