// Force all lines to require a semi-colon to signify the end of the line
#pragma semicolon 1
// core includes
#define REQUIRE_PLUGIN
#include <sourcemod>
#undef REQUIRE_PLUGIN
#include <atac>
#define REQUIRE_EXTENSIONS
#include <sdktools>

#define YELLOW 0x01
#define TEAMCOLOR 0X03
#define GREEN 0x04
#define ATAC_VERSION "2.5.0"

// Plugin definitions
public Plugin:myinfo = 
{
	name = "ATAC Punishment UberSlap",
	author = "FlyingMongoose",
	description = "UberSlap Punishment for ATAC",
	version = ATAC_VERSION,
	url = "http://www.steamfriends.com/"
};

//new Handle:UberSlapTime[MAXPLAYERS+1][MAXPLAYERS+1];
new Handle:SlayDelayTimerHandle[MAXPLAYERS+1];
new Handle:UberSlapTimerHandle = INVALID_HANDLE;
new bool:UberSlapNextSpawn[MAXPLAYERS+1][MAXPLAYERS+1];
new bool:BeingUberSlapped[MAXPLAYERS+1];


new g_Lightning;
new g_ExplosionFire;
new g_Smoke1;
new g_Smoke2;
new g_FireBurst;

new Handle:Punishment;

public OnPluginStart(){
	LoadTranslations("atac_uberslap.phrases");
}

public OnATACLoaded(){
	HookEvent("player_spawn",ev_PlayerSpawn);
	//HookEvent("player_death",ev_PlayerDeath);
	decl String:UberSlapStr[128];
	Format(UberSlapStr,sizeof(UberSlapStr),"%t","Menu UberSlap");
	Punishment = RegisterPunishment("MenuUberSlap",UberSlapStr);
	
	RegAdminCmd("sm_uberslapme",Command_UberslapMe,ADMFLAG_RCON);
}

public Action:Command_UberslapMe(client,args)
{
	MenuUberSlap(client,client);
	return Plugin_Handled;
}

public MenuUberSlap(victim,attacker){
	if(attacker != 0 && victim != 0){
		new CurrTKValue = ATACGetClient(TEAMKILLS,attacker);
		new newTKValue = CurrTKValue + 1;
		
		decl String:attackerName[64];
		GetClientName(attacker,attackerName,sizeof(attackerName));
				
		ATACSetClient(TEAMKILLS,attacker,newTKValue);
		if(IsClientConnected(attacker) && IsClientInGame(attacker)){
			//decl String:attackerName[64];
			//GetClientName(attacker,attackerName,sizeof(attackerName));
			
			if (IsPlayerAlive(attacker)){
				UberSlap(victim,attacker);
			}else{
				PrintToConsole(victim,"[ATAC] %t","UberSlap Next Spawn",attackerName);
				PrintToChat(victim,"%c[ATAC]%c %t",GREEN,YELLOW,"UberSlap Next Spawn",attackerName);
				UberSlapNextSpawn[attacker][victim] = true;
			}
		}
	}
}

public Action:SlayDelay(Handle:timer, any:attacker)
{
	new bool:clientConnected = IsClientConnected(attacker);
	
	for (new victim=1; victim<GetMaxClients(); ++victim)
	{
		if (clientConnected)
		{
			UberSlapNextSpawn[attacker][victim] = false;
			continue;
		}
		
		if (UberSlapNextSpawn[attacker][victim])
		{
			UberSlap(victim,attacker);
		}
		
		UberSlapNextSpawn[attacker][victim] = false;
	}	
}

public OnPluginEnd(){
	UnregisterPunishment(Punishment);
}

UberSlap(victim,attacker){
	if(IsClientInGame(attacker) && IsClientInGame(victim)){
		decl String:attackerName[64];
		GetClientName(attacker,attackerName,64);
		PrintToConsole(victim,"[ATAC] %t","Punish UberSlap",attackerName,ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
		PrintToChat(victim,"%c[ATAC]%c %t",GREEN,YELLOW,"Punish UberSlap",attackerName,ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
		PrintToConsole(attacker,"[ATAC] %t","Were UberSlapped",ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
		PrintToChat(attacker,"%c[ATAC]%c %t",GREEN,YELLOW,"Were UberSlapped",ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
		
		//UberSlapTime[victim][attacker] = CreateTimer(0.1,UberSlapTimer,attacker,TIMER_REPEAT);
		BeingUberSlapped[attacker] = true;
	}
}

public Action:UberSlapTimer(Handle:timer, any:notused)
{
	for (new i=1; i<=GetMaxClients(); ++i)
	{
		if(IsClientConnected(i) && IsClientInGame(i) && BeingUberSlapped[i])
		{
			if(!IsPlayerAlive(i) || GetClientHealth(i) <= 0)
			{
				SlayEffects(i);
				ForcePlayerSuicide(i);
				BeingUberSlapped[i] = false;
				return Plugin_Stop;
			}
			Lightning(i);
			SlapPlayer(i,1);
			return Plugin_Continue;
		}
		else if (BeingUberSlapped[i])
		{
			BeingUberSlapped[i] = false;
			return Plugin_Stop;
		}
	}
	return Plugin_Continue;
}

public ev_PlayerSpawn(Handle:event, const String:name[], bool:dontBroadcast){
	new client = GetClientOfUserId(GetEventInt(event,"userid"));
	new bool:clientConnected = IsClientConnected(client);
	for(new i = 1; i <= GetMaxClients(); ++i)
	{
		if (!clientConnected)
		{
			UberSlapNextSpawn[client][i] = false;
			continue;
		}
		
		if(UberSlapNextSpawn[client][i])
		{
			new Float:delay = float(ATACGetPunishDelay());
			SlayDelayTimerHandle[client] = CreateTimer(delay,SlayDelay,client);
		}
	}
}

/*public ev_PlayerDeath(Handle:event, const String:name[], bool:dontBroadcast){
	new client = GetClientOfUserId(GetEventInt(event,"userid"));
	for(new i = 1; i <= GetMaxClients(); ++i){
		if(BeingUberSlapped[client][i]){
			BeingUberSlapped[client][i] = false;
		}
	}
}*/

public OnMapEnd()
{
	for(new client = 1; client <= GetMaxClients(); ++client)
	{
		BeingUberSlapped[client] = false;
	}
	
	if (UberSlapTimerHandle != INVALID_HANDLE)
	{
		KillTimer(UberSlapTimerHandle);
		UberSlapTimerHandle = INVALID_HANDLE;
	}

}

public OnMapStart(){
	g_Lightning = PrecacheModel("materials/sprites/tp_beam001.vmt", false);
	// Precache explosion
	g_ExplosionFire = PrecacheModel("materials/effects/fire_cloud1.vmt",false);
	// precache smoke
	g_Smoke1 = PrecacheModel("materials/effects/fire_cloud1.vmt",false);
	// precache another smoke
	g_Smoke2 = PrecacheModel("materials/effects/fire_cloud2.vmt",false);
	// precache a little fire
	g_FireBurst = PrecacheModel("materials/sprites/fireburst.vmt",false);
	// precache the explosion sound (used with slay)
	PrecacheSound("ambient/explosions/explode_8.wav",false);
	// Make sure everything loaded right
	if(g_Lightning == 0 || g_Smoke1 == 0 || g_Smoke2 == 0 || g_FireBurst == 0 || g_ExplosionFire == 0 || !IsSoundPrecached("ambient/explosions/explode_8.wav")){
		SetFailState("[UberSlap] Precache Failed");
	}
	
	if (INVALID_HANDLE == UberSlapTimerHandle)
		UberSlapTimerHandle = CreateTimer(0.1,UberSlapTimer,INVALID_HANDLE,TIMER_REPEAT);

}

// nifty pretties
stock SlayEffects(client)
{
	// get player position
	new Float:playerpos[3];
	GetClientAbsOrigin(client,playerpos);
	
	// set lightning settings
	// set the top coordinates of the lightning effect
	new Float:toppos[3];
	toppos[0] = playerpos[0];
	toppos[1] = playerpos[1];
	toppos[2] = playerpos[2]+1000;
	// set the color of the lightning
	new lightningcolor[4];
	lightningcolor[0] = 255;
	lightningcolor[1] = 255;
	lightningcolor[2] = 255;
	lightningcolor[3] = 255;
	// how long lightning lasts
	new Float:lightninglife = 2.0;
	// width of lightning at top
	new Float:lightningwidth = 5.0;
	// width of lightning at bottom
	new Float:lightningendwidth = 5.0;
	// lightning start frame
	new lightningstartframe = 0;
	// lightning frame rate
	new lightningframerate = 1;
	// how long it takes for lightning to fade
	new lightningfadelength = 1;
	// how bright lightning is
	new Float:lightningamplitude = 1.0;
	// how fast the effect is drawn
	new lightningspeed = 250;
	
	// set smoke settings
	// how wide a 360 degree radius of smoke should be used
	new Float:smokescale = 50.0;
	// frame rate for smoke
	new smokeframerate = 2;
	
	// coordinates for smoke effecet
	new Float:SmokePos[3];
	SmokePos[0] = playerpos[0];
	SmokePos[1] = playerpos[1];
	SmokePos[2] = playerpos[2] + 10;
	
	// coordinates for uppy body/head smoke efect
	new Float:PlayerHeadPos[3];
	PlayerHeadPos[0] = playerpos[0];
	PlayerHeadPos[1] = playerpos[1];
	PlayerHeadPos[2] = playerpos[2] + 100;
	
	// should the smoke be "blown" somewhere.
	new Float:direction[3];
	direction[0] = 0.0;
	direction[1] = 0.0;
	direction[2] = 0.0;
	
	new Float:sparkstart[3];
	sparkstart[0] = playerpos[0];
	sparkstart[1] = playerpos[1];
	sparkstart[2] = playerpos[2] + 13.0;
	
	new Float:sparkdir[3];
	sparkdir[0] = playerpos[0];
	sparkdir[1] = playerpos[1];
	sparkdir[2] = playerpos[2] + 23.0;
	
	// create lightning effects and sparks, and explosion
	TE_SetupBeamPoints(toppos, playerpos, g_Lightning, g_Lightning, lightningstartframe, lightningframerate, lightninglife, lightningwidth, lightningendwidth, lightningfadelength, lightningamplitude, lightningcolor, lightningspeed);
	TE_SetupExplosion(playerpos, g_ExplosionFire, 10.0, 10, TE_EXPLFLAG_NONE, 200, 255);
	TE_SetupSmoke(playerpos, g_Smoke1, smokescale, smokeframerate);
	TE_SetupSmoke(playerpos, g_Smoke2, smokescale, smokeframerate);
	TE_SetupMetalSparks(sparkstart,sparkdir);
	
	
	TE_SendToAll(0.0);
	EmitAmbientSound("ambient/explosions/explode_8.wav", playerpos, SOUND_FROM_WORLD, SNDLEVEL_NORMAL, SND_NOFLAGS, 1.0, SNDPITCH_NORMAL, 0.0);
}

stock Lightning(client)
{
	// get player position
	new Float:playerpos[3];
	GetClientAbsOrigin(client,playerpos);
	
	// set lightning settings
	// set the top coordinates of the lightning effect
	new Float:toppos[3];
	toppos[0] = playerpos[0];
	toppos[1] = playerpos[1];
	toppos[2] = playerpos[2]+1000;
	// set the color of the lightning
	new lightningcolor[4];
	lightningcolor[0] = 255;
	lightningcolor[1] = 255;
	lightningcolor[2] = 255;
	lightningcolor[3] = 255;
	
	// how long lightning lasts
	new Float:lightninglife = 0.1;
	// width of lightning at top
	new Float:lightningwidth = 5.0;
	// width of lightning at bottom
	new Float:lightningendwidth = 5.0;
	// lightning start frame
	new lightningstartframe = 0;
	// lightning frame rate
	new lightningframerate = 1;
	// how long it takes for lightning to fade
	new lightningfadelength = 1;
	// how bright lightning is
	new Float:lightningamplitude = 1.0;
	// how fast the effect is drawn
	new lightningspeed = 250;
	
	TE_SetupBeamPoints(toppos, playerpos, g_Lightning, g_Lightning, lightningstartframe, lightningframerate, lightninglife, lightningwidth, lightningendwidth, lightningfadelength, lightningamplitude, lightningcolor, lightningspeed);
	
	TE_SendToAll(0.0);
}

public OnClientDisconnect(client)
{
	for(new victim = 1; victim <= GetMaxClients(); ++victim){
		if(UberSlapNextSpawn[client][victim]){
			UberSlapNextSpawn[client][victim] = false;
		}
	}
	if(BeingUberSlapped[client])
		BeingUberSlapped[client] = false;
	if (UberSlapTimerHandle != INVALID_HANDLE)
	{
		KillTimer(UberSlapTimerHandle);
		UberSlapTimerHandle = INVALID_HANDLE;
	}
	if(SlayDelayTimerHandle[client] != INVALID_HANDLE)
	{
		KillTimer(SlayDelayTimerHandle[client]);
		SlayDelayTimerHandle[client] = INVALID_HANDLE; 
	}
}