#pragma semicolon 1
#pragma dynamic 65536
#define REQUIRE_PLUGIN
#include <sourcemod>
#undef REQUIRE_PLUGIN
#include <atac>
#define REQUIRE_EXTENSIONS
#include <sdktools>
#undef REQUIRE_EXTENSIONS

#define YELLOW 0x01
#define TEAMCOLOR 0X03
#define GREEN 0x04
#define ATAC_VERSION "2.5.0"

public Plugin:myinfo =
{
	name = "ATAC Punishment Slap",
	author = "FlyingMongoose",
	description = "Slap punishment for ATAC",
	version = ATAC_VERSION,
	url = "http://www.steamfriends.com/"
};

new Handle:cvarSlapDamage;
new bool:SlapNextSpawn[MAXPLAYERS+1];
new bool:deadpunished[MAXPLAYERS+1][MAXPLAYERS+1];

new Handle:TimerHandle[MAXPLAYERS+1] = INVALID_HANDLE;

new Handle:Punishment;

public OnPluginStart(){
	LoadTranslations("atac.phrases");
	LoadTranslations("atac_slap.phrases");
	cvarSlapDamage = CreateConVar("atac_slapdamage","50","Value to slap for when slap is selected from the punishment menu",FCVAR_PLUGIN,true,0.0,true,100.0);
	AutoExecConfig(true,"atac_slap","sourcemod");
}

public OnATACLoaded(){
	HookEvent("player_spawn",ev_PlayerSpawn);
	decl String:SlapStr[128];
	Format(SlapStr,sizeof(SlapStr),"%t","Slap For Damage",GetConVarInt(cvarSlapDamage));
	Punishment = RegisterPunishment("MenuSlap",SlapStr);
}

public OnPluginEnd(){
	UnregisterPunishment(Punishment);
}

public MenuSlap(victim,attacker){
	if(victim != 0 && attacker != 0){
		new CurrTKValue = ATACGetClient(TEAMKILLS,attacker);
		new newTKValue = CurrTKValue + 1;
		ATACSetClient(TEAMKILLS,attacker,newTKValue);
		if(IsClientConnected(attacker) && IsClientInGame(attacker)){
			decl String:attackerName[64];
			GetClientName(attacker,attackerName,sizeof(attackerName));
			if(IsPlayerAlive(attacker)){
				SlapClient(attacker,victim);
			}else{
				PrintToConsole(victim,"[ATAC] %t","Next Spawn",attackerName);
				PrintToChat(victim,"%c[ATAC]%c %t",GREEN,YELLOW,"Next Spawn",attackerName);
				SlapNextSpawn[attacker] = true;
				deadpunished[attacker][victim] = true;
			}
		}
	}
}

public ev_PlayerSpawn(Handle:event, const String:name[], bool:dontBroadcast){
	new client = GetClientOfUserId(GetEventInt(event,"userid"));
	if(IsClientConnected(client) && SlapNextSpawn[client]){
		new Float:delay = float(ATACGetPunishDelay());
		TimerHandle[client] = CreateTimer(delay,SlapDelay);
	}
}

public Action:SlapDelay(Handle:timer){
	decl String:attackerName[64];
	new slapDamage = GetConVarInt(cvarSlapDamage);
	for(new attacker = 1; attacker <= GetMaxClients(); ++attacker){
		if(IsClientConnected(attacker) && IsClientInGame(attacker) && SlapNextSpawn[attacker]){
			GetClientName(attacker,attackerName,sizeof(attackerName));
			SlapPlayer(attacker,slapDamage);
			for(new victim = 1; victim <= GetMaxClients(); ++victim){
				if(deadpunished[attacker][victim]){
					SlapClient(attacker,victim);
					deadpunished[attacker][victim] = false;
				}
			}
			SlapNextSpawn[attacker] = false;
		}
	}
}

SlapClient(attacker,victim){
	if (!IsClientInGame(attacker) || !IsClientInGame(victim))
		return;

	decl String:attackerName[64];
	GetClientName(attacker,attackerName,64);
	PrintToConsole(victim,"[ATAC] %t","Been Slapped",attackerName,ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	PrintToChat(victim,"%c[ATAC]%c %t",GREEN,YELLOW,"Been Slapped",attackerName,ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	PrintToConsole(attacker,"[ATAC] %t","Were Slapped",ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	PrintToChat(attacker,"%c[ATAC]%c %t",GREEN,YELLOW,"Were Slapped",ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	SlapPlayer(attacker,GetConVarInt(cvarSlapDamage));
}



public OnClientDisconnect(client){
	for(new victim = 1; victim <= GetMaxClients(); ++victim){
		if(deadpunished[client][victim]){
			deadpunished[client][victim] = false;
			SlapNextSpawn[client] = false;
		}
	}
	if(SlapNextSpawn[client])
		SlapNextSpawn[client] = true;
	if(TimerHandle[client] != INVALID_HANDLE)
	{
		KillTimer(TimerHandle[client],true);
		TimerHandle[client] = INVALID_HANDLE;
	}
}