#pragma semicolon 1
#define REQUIRE_PLUGIN
#include <sourcemod>
#undef REQUIRE_PLUGIN
#include <atac>
#include <irc-relay>

#define YELLOW 0x01
#define TEAMCOLOR 0X03
#define GREEN 0x04
#define ATAC_VERSION "2.5.0"

public Plugin:myinfo = 
{
	name = "ATAC IRC Relay Bridge",
	author = "FlyingMongoose",
	description = "Bridge between ATAC and IRC Relay",
	version = ATAC_VERSION,
	url = "http://www.steamfriends.com/"
}


new Handle:cvarATACIrcRelay;
new Handle:cvarATACIrcTKStatus;
new Handle:cvarATACIrcGetKarma;
new Handle:cvarATACIrcGetTA;
new Handle:cvarATACIrcGetTK;
new Handle:cvarATACIrcGetKicks;
new Handle:cvarATACIrcGetBans;
new Handle:cvarATACIrcSetKarma;
new Handle:cvarATACIrcSetTA;
new Handle:cvarATACIrcSetTK;
new Handle:cvarATACIrcSetKicks;
new Handle:cvarATACIrcSetBans;

new bool:g_ircRelay;

public GetCmdArgvInt(param)
{
	decl String:strValue[64];
	IRC_GetCmdArgv(param,strValue,sizeof(strValue));
	return StringToInt(strValue);
}

public OnPluginStart()
{
	LoadTranslations("atac_ircrelay.phrases");
	cvarATACIrcRelay = CreateConVar("atac_ircrelay","0","Enabled/disables IRC Relay functionality",FCVAR_PLUGIN,true, 0.0, true, 1.0);
	cvarATACIrcTKStatus = CreateConVar("atac_tkstatuslevel","0","Access level of IRC user to use tkstatus command.",FCVAR_PLUGIN,true,0.0,true,300.0);
	cvarATACIrcGetKarma = CreateConVar("atac_getkarmalevel","0","Access level of IRC user to use getkarma command,",FCVAR_PLUGIN,true,0.0,true,300.0);
	cvarATACIrcGetTA = CreateConVar("atac_gettalevel","0","Access level of IRC user to use getteamattacks command.",FCVAR_PLUGIN,true,0.0,true,300.0);
	cvarATACIrcGetTK = CreateConVar("atac_gettklevel","0","Access level of IRC user to use getteamkills command.",FCVAR_PLUGIN,true,0.0,true,300.0);
	cvarATACIrcGetKicks = CreateConVar("atac_getkickslevel","0","Access level of IRC user to use getkicks command.",FCVAR_PLUGIN,true,0.0,true,300.0);
	cvarATACIrcGetBans = CreateConVar("atac_getbanslevel","0","Access level of IRC user to use getbans command.",FCVAR_PLUGIN,true,0.0,true,300.0);
	cvarATACIrcSetKarma = CreateConVar("atac_setkarmalevel","250","Access level of IRC user to use setkarma command.",FCVAR_PLUGIN,true,0.0,true,300.0);
	cvarATACIrcSetTA = CreateConVar("atac_settalevel","250","Access level of IRC user to use setkarma command.",FCVAR_PLUGIN,true,0.0,true,300.0);
	cvarATACIrcSetTK = CreateConVar("atac_settklevel","250","Access level of IRC user to use settk command.",FCVAR_PLUGIN,true,0.0,true,300.0);
	cvarATACIrcSetKicks = CreateConVar("atac_setkickslevel","250","Access level of IRC user to use setkicks comand.",FCVAR_PLUGIN,true,0.0,true,300.0);
	cvarATACIrcSetBans = CreateConVar("atac_setbanslevel","250","Access level of IRC user to use setbans commands.",FCVAR_PLUGIN,true,0.0,true,300.0);
 
	AutoExecConfig(true,"atac_ircrelay","sourcemod");
}

ReplyTypeValue(){
	new Handle:ReplyTypeHandle = FindConVar("irc_relay_replytype");
	if(ReplyTypeHandle != INVALID_HANDLE){
		new ReplyType = GetConVarInt(ReplyTypeHandle);
		return ReplyType;
	}else{
		return 0;
	}
}

public OnATACLoaded()
{
	if(GetConVarBool(cvarATACIrcRelay)){
		g_ircRelay = true;
		IRC_RegisterCommand("tkstatus",IRC_Tag_CommandCallback:FindTKStatus,GetConVarInt(cvarATACIrcTKStatus));
		IRC_RegisterCommand("getkarma",IRC_Tag_CommandCallback:FindKarma,GetConVarInt(cvarATACIrcGetKarma));
		IRC_RegisterCommand("getteamattacks",IRC_Tag_CommandCallback:FindTeamAttacks,GetConVarInt(cvarATACIrcGetTA));
		IRC_RegisterCommand("getteamkills",IRC_Tag_CommandCallback:FindTeamKills,GetConVarInt(cvarATACIrcGetTK));
		IRC_RegisterCommand("getkicks",IRC_Tag_CommandCallback:FindKicks,GetConVarInt(cvarATACIrcGetKicks));
		IRC_RegisterCommand("getbans",IRC_Tag_CommandCallback:FindBans,GetConVarInt(cvarATACIrcGetBans));
		IRC_RegisterCommand("setkarma",IRC_Tag_CommandCallback:SetClientKarma,GetConVarInt(cvarATACIrcSetKarma));
		IRC_RegisterCommand("setteamattacks",IRC_Tag_CommandCallback:SetClientTA,GetConVarInt(cvarATACIrcSetTA));
		IRC_RegisterCommand("setteamkills",IRC_Tag_CommandCallback:SetClientTK,GetConVarInt(cvarATACIrcSetTK));
		IRC_RegisterCommand("setkicks",IRC_Tag_CommandCallback:SetClientKicks,GetConVarInt(cvarATACIrcSetKicks));
		IRC_RegisterCommand("setbans",IRC_Tag_CommandCallback:SetClientBans,GetConVarInt(cvarATACIrcSetBans));
	}else{
		g_ircRelay = false;
	}
}

public IRC_Tag_CommandCallback:SetClientKarma(const argc)
{
	if(g_ircRelay){
		new String:destination[64];
		IRC_GetMsgDestination(destination, sizeof(destination));
		if(argc <= 1)
		{
				IRC_PrivMsg(destination,"Usage: !<trigger>.setkarma playername value");
				return;
		}
		decl String:player[512];
		IRC_GetCmdArgv(0,player,sizeof(player));
		new client = FindPlayerName(player);
		
		if(client == -1){
			IRC_PrivMsg(destination,"[ATAC] %t","IRC Client Not Found");
			return;
		}else if(client == -2){
			IRC_PrivMsg(destination,"[ATAC] %t","IRC Duplicate Clients");
			return;
		}else{
				
			new karmaValue = GetCmdArgvInt(1);
					
			decl String:clientName[100];
			GetClientName(client,clientName,sizeof(clientName));
			
			ATACSetClient(KARMA,client,karmaValue);
			
			new karmaCount = ATACGetClient(KARMA,client);
			new maxKarma = ATACGetMax(KARMA);
			
			decl String:karmaSetOutput[255];
			Format(karmaSetOutput,sizeof(karmaSetOutput),"[ATAC] %t","IRC Set Karma",clientName,karmaCount,maxKarma);
			
			IRC_PrivMsg(destination,karmaSetOutput);
			return;
		}
	}
}

public IRC_Tag_CommandCallback:SetClientTA(const argc)
{
	if(g_ircRelay){
		new String:destination[64];
		IRC_GetMsgDestination(destination, sizeof(destination));
		if(argc <= 1)
		{
				IRC_PrivMsg(destination,"Usage: !<trigger>.setteamattacks playername value");
				return;
		}
		decl String:player[512];
		IRC_GetCmdArgv(0,player,sizeof(player));
		new client = FindPlayerName(player);
		if(client == -1){
			IRC_PrivMsg(destination,"[ATAC] %t","IRC Client Not Found");
			return;
		}else if(client == -2){
			IRC_PrivMsg(destination,"[ATAC] %t","IRC Duplicate Clients");
			return;
		}else{
			new taValue = GetCmdArgvInt(1);
					
			decl String:clientName[100];
			GetClientName(client,clientName,sizeof(clientName));
			
			ATACSetClient(TEAMATTACKS,client,taValue);
			
			new taCount = ATACGetClient(TEAMATTACKS,client);
			new maxTA = ATACGetMax(TEAMATTACKS);
			
			decl String:taSetOutput[255];
			Format(taSetOutput,sizeof(taSetOutput),"[ATAC] %t","IRC Set TA",clientName,taCount,maxTA);
			
			IRC_PrivMsg(destination,taSetOutput);
			return;
		}
	}
}

public IRC_Tag_CommandCallback:SetClientTK(const argc)
{
	if(g_ircRelay){
		new String:destination[64];
		IRC_GetMsgDestination(destination, sizeof(destination));
		if(argc <= 1)
		{
				IRC_PrivMsg(destination,"Usage: !<trigger>.setteamkills playername value");
				return;
		}
		decl String:player[512];
		IRC_GetCmdArgv(0,player,sizeof(player));
		new client = FindPlayerName(player);
		if(client == -1){
			IRC_PrivMsg(destination,"[ATAC] %t","IRC Client Not Found");
			return;
		}else if(client == -2){
			IRC_PrivMsg(destination,"[ATAC] %t","IRC Duplicate Clients");
			return;
		}else{
			new tkValue = GetCmdArgvInt(1);
					
			decl String:clientName[100];
			GetClientName(client,clientName,sizeof(clientName));
			
			ATACSetClient(TEAMKILLS,client,tkValue);
			
			new tkCount = ATACGetClient(TEAMKILLS,client);
			new maxTK = ATACGetMax(TEAMKILLS);
			
			decl String:tkSetOutput[255];
			Format(tkSetOutput,sizeof(tkSetOutput),"[ATAC] %t","IRC Set TK",clientName,tkCount,maxTK);
			
			IRC_PrivMsg(destination,tkSetOutput);
			return;
		}
	}
}

public IRC_Tag_CommandCallback:SetClientKicks(const argc)
{
	if(g_ircRelay){
		new String:destination[64];
		IRC_GetMsgDestination(destination, sizeof(destination));
		if(argc <= 1)
		{
				IRC_PrivMsg(destination,"Usage: !<trigger>.setkicks playername value");
				return;
		}
		decl String:player[512];
		IRC_GetCmdArgv(0,player,sizeof(player));
		new client = FindPlayerName(player);
		if(client == -1){
			IRC_PrivMsg(destination,"[ATAC] %t","IRC Client Not Found");
			return;
		}else if(client == -2){
			IRC_PrivMsg(destination,"[ATAC] %t","IRC Duplicate Clients");
			return;
		}else{
		
			new kickValue = GetCmdArgvInt(1);
					
			decl String:clientName[100];
			GetClientName(client,clientName,sizeof(clientName));
			
			ATACSetClient(KICKCOUNT,client,kickValue);
			
			new kickCount = ATACGetClient(KICKCOUNT,client);
			new maxKicks = ATACGetMax(KICKCOUNT);
			
			decl String:kickSetOutput[255];
			Format(kickSetOutput,sizeof(kickSetOutput),"[ATAC] %t","IRC Set Kicks",clientName,kickCount,maxKicks);
			
			IRC_PrivMsg(destination,kickSetOutput);
			return;
		}
	}
}

public IRC_Tag_CommandCallback:SetClientBans(const argc)
{
	if(g_ircRelay){
		new String:destination[64];
		IRC_GetMsgDestination(destination, sizeof(destination));
		if(argc <= 1)
		{
				IRC_PrivMsg(destination,"Usage: !<trigger>.setbans playername value");
				return;
		}
		decl String:player[512];
		IRC_GetCmdArgv(0,player,sizeof(player));
		new client = FindPlayerName(player);
		if(client == -1){
			IRC_PrivMsg(destination,"[ATAC] %t","IRC Client Not Found");
			return;
		}else if(client == -2){
			IRC_PrivMsg(destination,"[ATAC] %t","IRC Duplicate Clients");
			return;
		}else{
		
			new banValue = GetCmdArgvInt(1);
					
			decl String:clientName[100];
			GetClientName(client,clientName,sizeof(clientName));
			
			ATACSetClient(BANCOUNT,client,banValue);
			
			new banCount = ATACGetClient(BANCOUNT,client);
			new maxBans = ATACGetMax(BANCOUNT);
			
			decl String:banSetOutput[255];
			Format(banSetOutput,sizeof(banSetOutput),"[ATAC] %t","IRC Set Bans",clientName,banCount,maxBans);
			
			IRC_PrivMsg(destination,banSetOutput);
			return;
		}
	}
}

public IRC_Tag_CommandCallback:FindTKStatus(const argc)
{
	if(g_ircRelay){
		decl String:destination[64];
		IRC_GetMsgDestination(destination, sizeof(destination));
		if(argc < 1)
		{
			IRC_PrivMsg(destination,"Usage: !<trigger>.tkstatus playername");
			return;
		}
		decl String:message[512];
		IRC_GetCmdArgv(0,message, sizeof(message));
		new client = FindPlayerName(message);
		if(client == -1){
			IRC_PrivMsg(destination,"[ATAC] %t","IRC Client Not Found");
			return;
		}else if(client == -2){
			IRC_PrivMsg(destination,"[ATAC] %t","IRC Duplicate Clients");
			return;
		}else{
			decl String:clientName[100];
			decl String:panelTitle[255];
			decl String:panelKarmaCount[255];
			decl String:panelTACount[255];
			decl String:panelTKCount[255];
			decl String:panelKickCount[255];
			decl String:panelBanCount[255];
		
			GetClientName(client,clientName,sizeof(clientName));
			new karmaCount = ATACGetClient(KARMA,client);
			new taCount = ATACGetClient(TEAMATTACKS,client);
			new tkCount = ATACGetClient(TEAMKILLS,client);
			new kickCount = ATACGetClient(KICKCOUNT,client);
			new banCount = ATACGetClient(BANCOUNT,client);
			new maxKarma = ATACGetMax(KARMA);
			new maxTA = ATACGetMax(TEAMATTACKS);
			new maxTK = ATACGetMax(TEAMKILLS);
			new maxKicks = ATACGetMax(KICKCOUNT);
			new maxBans = ATACGetMax(BANCOUNT);
			Format(panelTitle,sizeof(panelTitle),"[ATAC] %t","IRC TK Status Title",clientName);
			Format(panelKarmaCount,sizeof(panelKarmaCount),"[ATAC] %t","IRC Karma Count",clientName,karmaCount,maxKarma);
			Format(panelTACount,sizeof(panelTACount),"[ATAC] %t","IRC TA Count",clientName,taCount,maxTA);
			Format(panelTKCount,sizeof(panelTKCount),"[ATAC] %t","IRC TK Count",clientName,tkCount,maxTK);
			Format(panelKickCount,sizeof(panelKickCount),"[ATAC] %t","IRC Kick Count",clientName,kickCount,maxKicks);
			Format(panelBanCount,sizeof(panelBanCount),"[ATAC] %t","IRC Ban Count",clientName,banCount,maxBans);
			
			IRC_PrivMsg(destination,panelTitle);
			IRC_PrivMsg(destination,panelKarmaCount);
			IRC_PrivMsg(destination,panelTACount);
			IRC_PrivMsg(destination,panelTKCount);
			IRC_PrivMsg(destination,panelKickCount);
			IRC_PrivMsg(destination,panelBanCount);
			return;
		}
	}
}

public IRC_Tag_CommandCallback:FindKarma(const argc)
{
	if(g_ircRelay)
	{
		decl String:destination[64];
		IRC_GetMsgDestination(destination,sizeof(destination));
		if(argc < 1)
		{
			IRC_PrivMsg(destination,"Usage: !<trigger>.getkarma playername");
			return;
		}
		decl String:message[512];
		IRC_GetCmdArgv(0,message,sizeof(message));
		new client = FindPlayerName(message);
		if(client == -1){
			IRC_PrivMsg(destination,"[ATAC] %t","IRC Client Not Found");
			return;
		}else if(client == -2){
			IRC_PrivMsg(destination,"[ATAC] %t","IRC Duplicate Clients");
			return;
		}else{
		
			decl String:clientName[100];
			decl String:panelKarmaCount[255];
			
			GetClientName(client,clientName,sizeof(clientName));
			new karmaCount = ATACGetClient(KARMA,client);
			new maxKarma = ATACGetMax(KARMA);
			
			Format(panelKarmaCount,sizeof(panelKarmaCount),"[ATAC] %t","IRC Karma Count",clientName,karmaCount,maxKarma);
			
			IRC_PrivMsg(destination,panelKarmaCount);
			return;
		}
	}
}

public IRC_Tag_CommandCallback:FindTeamAttacks(const argc)
{
	if(g_ircRelay)
	{
		decl String:destination[64];
		IRC_GetMsgDestination(destination,sizeof(destination));
		if(argc < 1)
		{
			IRC_PrivMsg(destination,"Usage: !<trigger>.getteamattacks playername");
			return;
		}
		decl String:message[512];
		IRC_GetCmdArgv(0,message,sizeof(message));
		new client = FindPlayerName(message);
		if(client == -1){
			IRC_PrivMsg(destination,"[ATAC] %t","IRC Client Not Found");
			return;
		}else if(client == -2){
			IRC_PrivMsg(destination,"[ATAC] %t","IRC Duplicate Clients");
			return;
		}else{
			decl String:clientName[100];
			decl String:panelTACount[255];
			
			GetClientName(client,clientName,sizeof(clientName));
			new taCount = ATACGetClient(TEAMATTACKS,client);
			new maxTA = ATACGetMax(TEAMATTACKS);
			
			Format(panelTACount,sizeof(panelTACount),"[ATAC] %t","IRC TA Count",clientName,taCount,maxTA);
			
			IRC_PrivMsg(destination,panelTACount);
			return;
		}
	}
}

public IRC_Tag_CommandCallback:FindTeamKills(const argc)
{
	if(g_ircRelay)
	{
		decl String:destination[64];
		IRC_GetMsgDestination(destination,sizeof(destination));
		if(argc < 1)
		{
			IRC_PrivMsg(destination,"Usage: !<trigger>.getteamkills playername");
			return;
		}
		decl String:message[512];
		IRC_GetCmdArgv(0,message,sizeof(message));
		new client = FindPlayerName(message);
		if(client == -1){
			IRC_PrivMsg(destination,"[ATAC] %t","IRC Client Not Found");
			return;
		}else if(client == -2){
			IRC_PrivMsg(destination,"[ATAC] %t","IRC Duplicate Clients");
			return;
		}else{
			decl String:clientName[100];
			decl String:panelTKCount[255];
			
			GetClientName(client,clientName,sizeof(clientName));
			new tkCount = ATACGetClient(TEAMKILLS,client);
			new maxTK = ATACGetMax(TEAMKILLS);
			
			Format(panelTKCount,sizeof(panelTKCount),"[ATAC] %t","IRC TK Count",clientName,tkCount,maxTK);
			
			IRC_PrivMsg(destination,panelTKCount);
			return;
		}
	}
}

public IRC_Tag_CommandCallback:FindKicks(const argc)
{
	if(g_ircRelay)
	{
		decl String:destination[64];
		IRC_GetMsgDestination(destination,sizeof(destination));
		if(argc < 1)
		{
			IRC_PrivMsg(destination,"Usage: !<trigger>.getkicks playername");
			return;
		}
		decl String:message[512];
		IRC_GetCmdArgv(0,message,sizeof(message));
		new client = FindPlayerName(message);
		if(client == -1){
			IRC_PrivMsg(destination,"[ATAC] %t","IRC Client Not Found");
			return;
		}else if(client == -2){
			IRC_PrivMsg(destination,"[ATAC] %t","IRC Duplicate Clients");
			return;
		}else{
			decl String:clientName[100];
			decl String:panelKickCount[255];
			
			GetClientName(client,clientName,sizeof(clientName));
			new kickCount = ATACGetClient(KICKCOUNT,client);
			new maxKicks = ATACGetMax(KICKCOUNT);
			
			Format(panelKickCount,sizeof(panelKickCount),"[ATAC] %t","IRC Kick Count",clientName,kickCount,maxKicks);
			
			IRC_PrivMsg(destination,panelKickCount);
			return;
		}
	}
}

public IRC_Tag_CommandCallback:FindBans(const argc)
{
	if(g_ircRelay)
	{
		decl String:destination[64];
		IRC_GetMsgDestination(destination,sizeof(destination));
		if(argc < 1)
		{
			IRC_PrivMsg(destination,"Usage: !<trigger>.getbans playername");
			return;
		}
		decl String:message[512];
		IRC_GetCmdArgv(0,message,sizeof(message));
		new client = FindPlayerName(message);
		if(client == -1){
			IRC_PrivMsg(destination,"[ATAC] %t","IRC Client Not Found");
			return;
		}else if(client == -2){
			IRC_PrivMsg(destination,"[ATAC] %t","IRC Duplicate Clients");
			return;
		}else{
			decl String:clientName[100];
			decl String:panelBanCount[255];
			
			GetClientName(client,clientName,sizeof(clientName));
			new banCount = ATACGetClient(BANCOUNT,client);
			new maxBans = ATACGetMax(BANCOUNT);
			
			Format(panelBanCount,sizeof(panelBanCount),"[ATAC] %t","IRC Ban Count",clientName,banCount,maxBans);
			
			IRC_PrivMsg(destination,panelBanCount);
			return;
		}
	}
}

public OnATACKickClient(attacker)
{
	if(g_ircRelay){
		decl String:attackerName[64];
		GetClientName(attacker,attackerName,64);
		decl String:SteamID[64];
		GetClientAuthString(attacker,SteamID,64);
		decl String:IrcMsg[1600];
		Format(IrcMsg,sizeof(IrcMsg),"\x02[ATAC]\x0F %t","IRC TK Kick",attackerName,SteamID);
		PrintToServer(IrcMsg);
		new ChanType = ReplyTypeValue();
		switch(ChanType){
			case 0:
				return;
			case 1:
				IRC_Broadcast(IRC_CHANNEL_PUBLIC,IrcMsg);
			case 2:
				IRC_Broadcast(IRC_CHANNEL_PRIVATE,IrcMsg);
			case 3:
				IRC_Broadcast(IRC_CHANNEL_BOTH,IrcMsg);
		}
		return;
	}
}

public OnATACBanClient(attacker)
{
	if(g_ircRelay){
		decl String:attackerName[64];
		GetClientName(attacker,attackerName,64);
		decl String:SteamID[64];
		GetClientAuthString(attacker,SteamID,64);
		decl String:IrcMsg[1600];
		Format(IrcMsg,sizeof(IrcMsg),"\x02[ATAC]\x0F %t","IRC TK Ban",attackerName,SteamID);
		PrintToServer(IrcMsg);
		new ChanType = ReplyTypeValue();
		switch(ChanType){
			case 0:
				return;
			case 1:
				IRC_Broadcast(IRC_CHANNEL_PUBLIC,IrcMsg);
			case 2:
				IRC_Broadcast(IRC_CHANNEL_PRIVATE,IrcMsg);
			case 3:
				IRC_Broadcast(IRC_CHANNEL_BOTH,IrcMsg);
		}
		return;
	}
}