#pragma semicolon 1
#pragma dynamic 65536
#define REQUIRE_PLUGIN
#include <sourcemod>
#undef REQUIRE_PLUGIN
#include <atac>
#define REQUIRE_EXTENSIONS
#include <sdktools>
#undef REQUIRE_EXTENSIONS

#define YELLOW 0x01
#define TEAMCOLOR 0x03
#define GREEN 0x04
#define ATAC_VERSION "2.5.0"

#include <sourcemod>
#include <atac>

new bool:FreezeBombNextSpawn[MAXPLAYERS+1];
new bool:punished[MAXPLAYERS+1][MAXPLAYERS+1];
new Handle:Punishment;
new Handle:TimerHandle[MAXPLAYERS+1] = INVALID_HANDLE;

public Plugin:myinfo = 
{
	name = "ATAC Punishment FreezeBomb",
	author = "FlyingMongoose",
	description = "Based on basefuncommands freeze bomb",
	version = ATAC_VERSION,
	url = "FlyingMongoose"
}

public OnPluginStart()
{
	LoadTranslations("atac.phrases");
	LoadTranslations("atac_freezebomb.phrases");
}

public OnATACLoaded(){
	HookEvent("player_spawn", ev_PlayerSpawn);
	decl String:FreezeBombStr[128];
	Format(FreezeBombStr,sizeof(FreezeBombStr),"%t","Menu FreezeBomb");
	Punishment = RegisterPunishment("MenuFreezeBomb",FreezeBombStr);
}

public OnPluginEnd(){
	UnregisterPunishment(Punishment);
}

public Action:MenuFreezeBomb(victim,attacker)
{
	if(attacker != 0 && victim != 0){
		if(IsClientInGame(attacker)){
			new CurrTKValue = ATACGetClient(TEAMKILLS,attacker);
			new newTKValue = CurrTKValue + 1;
			ATACSetClient(TEAMKILLS,attacker,newTKValue);
			decl String:attackerName[64];
			GetClientName(attacker,attackerName,sizeof(attackerName));
			if(IsClientConnected(attacker) && IsPlayerAlive(attacker)){
				punished[attacker][victim] = true;
				FreezeBombClient(attacker,victim);
				return Plugin_Handled;
			}else{
				PrintToConsole(victim,"[ATAC] %t","FreezeBomb Next Spawn",attackerName);
				PrintToChat(victim,"%c[ATAC]%c %t",GREEN,YELLOW,"FreezeBomb Next Spawn",attackerName);
				FreezeBombNextSpawn[attacker] = true;
				punished[attacker][victim] = true;
				return Plugin_Handled;
			}
		}
	}
	return Plugin_Continue;
}

public Action:FreezeBombDelay(Handle:timer){
	decl String:attackerName[64];
	for(new attacker = 1; attacker <= GetMaxClients(); ++attacker){
		if(IsClientConnected(attacker) && IsClientInGame(attacker) && FreezeBombNextSpawn[attacker]){
			GetClientName(attacker,attackerName,sizeof(attackerName));
			for(new victim = 1; victim <= GetMaxClients(); ++victim){
				if (punished[attacker][victim]){
					FreezeBombClient(attacker,victim);
					punished[attacker][victim] = false;
				}
			}
		}
		FreezeBombNextSpawn[attacker] = false;
	}
	return Plugin_Handled;
}

public Action:FreezeBombClient(attacker,victim)
{
	decl String:attackerName[64];
	GetClientName(attacker,attackerName,64);
	PrintToConsole(victim,"[ATAC] %t","Been Freeze Bombed",attackerName,ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	PrintToChat(victim,"%c[ATAC]%c %t",GREEN,YELLOW,"Been Freeze Bombed",attackerName,ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	PrintToConsole(attacker,"[ATAC] %t","Were Freeze Bombed",ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	PrintToChat(attacker,"%c[ATAC]%c %t",GREEN,YELLOW,"Were Freeze Bombed",ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	ServerCommand("sm_freezebomb %s",attackerName);
	return Plugin_Handled;
}

public ev_PlayerSpawn(Handle:event, const String:name[], bool:dontBroadcast)
{
	new client = GetClientOfUserId(GetEventInt(event,"userid"));
	if(FreezeBombNextSpawn[client] && IsClientConnected(client)){
		new Float:delay = float(ATACGetPunishDelay());
		TimerHandle[client] = CreateTimer(delay,FreezeBombDelay);
	}
}
public OnClientDisconnect(client){
	for(new victim = 1; victim <= GetMaxClients(); ++victim){
		if (punished[client][victim]){
			punished[client][victim] = false;
		}
	}
	if(FreezeBombNextSpawn[client])
		FreezeBombNextSpawn[client] = false;
	if(TimerHandle[client] != INVALID_HANDLE)
	{
		KillTimer(TimerHandle[client],true);
		TimerHandle[client] = INVALID_HANDLE;
	}
}