#pragma semicolon 1
#pragma dynamic 65536
#define REQUIRE_PLUGIN
#include <sourcemod>
#undef REQUIRE_PLUGIN
#include <atac>
#define REQUIRE_EXTENSIONS
#include <sdktools>
#undef REQUIRE_EXTENSIONS

#define YELLOW 0x01
#define TEAMCOLOR 0x03
#define GREEN 0x04
#define ATAC_VERSION "2.5.0"

#include <sourcemod>
#include <atac>

new bool:FreezeNextSpawn[MAXPLAYERS+1];
new bool:punished[MAXPLAYERS+1][MAXPLAYERS+1];
new Handle:Punishment;
new Handle:TimerHandle[MAXPLAYERS+1] = INVALID_HANDLE;

public Plugin:myinfo = 
{
	name = "ATAC Punishment Freeze",
	author = "FlyingMongoose",
	description = "Based on basefuncommands freeze",
	version = ATAC_VERSION,
	url = "FlyingMongoose"
}

public OnPluginStart()
{
	LoadTranslations("atac.phrases");
	LoadTranslations("atac_freeze.phrases");
}

public OnATACLoaded(){
	decl String:FreezeStr[128];
	Format(FreezeStr,sizeof(FreezeStr),"%t","Menu Freeze");
	Punishment = RegisterPunishment("MenuFreeze",FreezeStr);
}

public OnPluginEnd(){
	UnregisterPunishment(Punishment);
}

public Action:MenuFreeze(victim,attacker)
{
	if(attacker != 0 && victim != 0){
		if(IsClientInGame(attacker)){
			new CurrTKValue = ATACGetClient(TEAMKILLS,attacker);
			new newTKValue = CurrTKValue + 1;
			ATACSetClient(TEAMKILLS,attacker,newTKValue);
			decl String:attackerName[64];
			GetClientName(attacker,attackerName,sizeof(attackerName));
			if(IsClientConnected(attacker) && IsPlayerAlive(attacker)){
				punished[attacker][victim] = true;
				FreezeClient(attacker,victim);
				return Plugin_Handled;
			}else{
				PrintToConsole(victim,"[ATAC] %t","Freeze Next Spawn",attackerName);
				PrintToChat(victim,"%c[ATAC]%c %t",GREEN,YELLOW,"Freeze Next Spawn",attackerName);
				FreezeNextSpawn[attacker] = true;
				punished[attacker][victim] = true;
				return Plugin_Handled;
			}
		}
	}
	return Plugin_Continue;
}

public Action:FreezeDelay(Handle:timer){
	decl String:attackerName[64];
	for(new attacker = 1; attacker <= GetMaxClients(); ++attacker){
		if(IsClientConnected(attacker) && IsClientInGame(attacker) && FreezeNextSpawn[attacker]){
			GetClientName(attacker,attackerName,sizeof(attackerName));
			for(new victim = 1; victim <= GetMaxClients(); ++victim){
				if (punished[attacker][victim]){
					FreezeClient(attacker,victim);
					punished[attacker][victim] = false;
				}
			}
		}
		FreezeNextSpawn[attacker] = false;
	}
	return Plugin_Handled;
}

public Action:FreezeClient(attacker,victim)
{
	decl String:attackerName[64];
	GetClientName(attacker,attackerName,64);
	PrintToConsole(victim,"[ATAC] %t","Been Frozen",attackerName,ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	PrintToChat(victim,"%c[ATAC]%c %t",GREEN,YELLOW,"Been Frozen",attackerName,ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	PrintToConsole(attacker,"[ATAC] %t","Were Frozen",ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	PrintToChat(attacker,"%c[ATAC]%c %t",GREEN,YELLOW,"Were Frozen",ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	ServerCommand("sm_freeze %s",attackerName);
	return Plugin_Handled;
}

public ev_PlayerSpawn(Handle:event, const String:name[], bool:dontBroadcast)
{
	new client = GetClientOfUserId(GetEventInt(event,"userid"));
	if(IsClientConnected(client) && FreezeNextSpawn[client]){
		new Float:delay = float(ATACGetPunishDelay());
		TimerHandle[client] = CreateTimer(delay,FreezeDelay);
	}
}


public OnClientDisconnect(client){
	for(new victim = 1; victim <= GetMaxClients(); ++victim){
		if (punished[client][victim]){
			punished[client][victim] = false;
		}
	}
	if(FreezeNextSpawn[client])
		FreezeNextSpawn[client] = false;
	if(TimerHandle[client] != INVALID_HANDLE)
	{
		KillTimer(TimerHandle[client],true);
		TimerHandle[client] = INVALID_HANDLE;
	}
}