#pragma semicolon 1
#pragma dynamic 65536
#define REQUIRE_PLUGIN
#include <sourcemod>
#undef REQUIRE_PLUGIN
#include <atac>
#define REQUIRE_EXTENSIONS
#include <sdktools>
#undef REQUIRE_EXTENSIONS

#define YELLOW 0x01
#define TEAMCOLOR 0x03
#define GREEN 0x04
#define ATAC_VERSION "2.5.0"

#include <sourcemod>
#include <atac>

new bool:DrugNextSpawn[MAXPLAYERS+1];
new bool:punished[MAXPLAYERS+1][MAXPLAYERS+1];
new Handle:Punishment;
new Handle:TimerHandle[MAXPLAYERS+1] = INVALID_HANDLE;

public Plugin:myinfo = 
{
	name = "ATAC Punishment Drug",
	author = "FlyingMongoose",
	description = "Based on basefuncommands drug",
	version = ATAC_VERSION,
	url = "FlyingMongoose"
}

public OnPluginStart()
{
	LoadTranslations("atac.phrases");
	LoadTranslations("atac_drug.phrases");
}

public OnATACLoaded(){
	HookEvent("player_spawn",ev_PlayerSpawn);
	decl String:DrugStr[128];
	Format(DrugStr,sizeof(DrugStr),"%t","Menu Drug");
	Punishment = RegisterPunishment("MenuDrug",DrugStr);
}

public OnPluginEnd(){
	UnregisterPunishment(Punishment);
}

public Action:MenuDrug(victim,attacker)
{
	if(attacker != 0 && victim != 0){
		if(IsClientInGame(attacker)){
			new CurrTKValue = ATACGetClient(TEAMKILLS,attacker);
			new newTKValue = CurrTKValue + 1;
			ATACSetClient(TEAMKILLS,attacker,newTKValue);
			decl String:attackerName[64];
			GetClientName(attacker,attackerName,sizeof(attackerName));
			if(IsClientConnected(attacker) && IsPlayerAlive(attacker)){
				punished[attacker][victim] = true;
				DrugClient(attacker,victim);
				return Plugin_Handled;
			}else{
				PrintToConsole(victim,"[ATAC] %t","Drug Next Spawn",attackerName);
				PrintToChat(victim,"%c[ATAC]%c %t",GREEN,YELLOW,"Drug Next Spawn",attackerName);
				DrugNextSpawn[attacker] = true;
				punished[attacker][victim] = true;
				return Plugin_Handled;
			}
		}
	}
	return Plugin_Continue;
}

public Action:DrugDelay(Handle:timer){
	decl String:attackerName[64];
	for(new attacker = 1; attacker <= GetMaxClients(); ++attacker){
		if(IsClientConnected(attacker) && IsClientInGame(attacker) && DrugNextSpawn[attacker]){
			GetClientName(attacker,attackerName,sizeof(attackerName));
			for(new victim = 1; victim <= GetMaxClients(); ++victim){
				if (punished[attacker][victim]){
					DrugClient(attacker,victim);
					punished[attacker][victim] = false;
				}
			}
		}
		DrugNextSpawn[attacker] = false;
	}
	return Plugin_Handled;
}

public Action:DrugClient(attacker,victim)
{
	decl String:attackerName[64];
	GetClientName(attacker,attackerName,64);
	PrintToConsole(victim,"[ATAC] %t","Been Drugged",attackerName,ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	PrintToChat(victim,"%c[ATAC]%c %t",GREEN,YELLOW,"Been Drugged",attackerName,ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	PrintToConsole(attacker,"[ATAC] %t","Were Drugged",ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	PrintToChat(attacker,"%c[ATAC]%c %t",GREEN,YELLOW,"Were Drugged",ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	ServerCommand("sm_drug %s",attackerName);
	return Plugin_Handled;
}

public ev_PlayerSpawn(Handle:event, const String:name[], bool:dontBroadcast)
{
	new client = GetClientOfUserId(GetEventInt(event,"userid"));
	if(IsClientConnected(client) && DrugNextSpawn[client]){
		new Float:delay = float(ATACGetPunishDelay());
		TimerHandle[client] = CreateTimer(delay,DrugDelay);
	}
}

public OnClientDisconnect(client)
{
	for(new victim = 1; victim <= GetMaxClients(); ++victim){
		if (punished[client][victim]){
			punished[client][victim] = false;
		}
	}
	if(DrugNextSpawn[client])
		DrugNextSpawn[client] = false;
	if(TimerHandle[client] != INVALID_HANDLE)
	{
		KillTimer(TimerHandle[client],true);
		TimerHandle[client] = INVALID_HANDLE;
	}
}