#pragma semicolon 1
#define REQUIRE_PLUGIN
#include <sourcemod>
#undef REQUIRE_PLUGIN
#include <atac>
#define REQUIRE_EXTENSIONS
#include <sdktools>
#undef REQUIRE_EXTENSIONS


#define YELLOW 0x01
#define TEAMCOLOR 0x03
#define GREEN 0x04
#define ATAC_VERSION "2.5.0"

public Plugin:myinfo =
{
	name = "ATAC DoD: Source",
	author = "FlyingMongoose",
	description = "DoD: Source ATAC Plugin",
	version = ATAC_VERSION,
	url = "http://www.steamfriends.com/"
};

new Handle:cvarATACAdminImmunity;
new Handle:cvarATACIgnoreBots;
new Handle:cvarPointCaptureKarma;
new Handle:cvarCaptureBlockedKarma;
new Handle:cvarBombPlantedKarma;
new Handle:cvarBombExplodedKarma;
new Handle:cvarBombDefusedKarma;
new Handle:cvarKillPlanterKarma;
new Handle:cvarKillDefuserKarma;
new Handle:cvarRoundWinKarma;
new Handle:cvarATACProtectionTimer;
new Handle:cvarATACMirrorDamage;
new Handle:cvarATACHealMirrorDamage;
new Handle:cvarATACMirrorDamageSlap;

new g_SpawnTime[MAXPLAYERS+1];

new g_Lightning;
new g_ExplosionFire;
new g_Smoke1;
new g_Smoke2;
new g_FireBurst;


public OnPluginStart(){
	LoadTranslations("atac.phrases");
	LoadTranslations("atac_dods.phrases");
	decl String:GameName[PLATFORM_MAX_PATH];
	GetGameFolderName(GameName, sizeof(GameName));
	if(strcmp(GameName,"dod") != 0){
		SetFailState("[ATAC] atac_dods in wrong mod/game.");
	}else{
		cvarPointCaptureKarma = CreateConVar("atac_pointcapturekarma","3","Amount of karma to award for a point capture",FCVAR_PLUGIN,true,0.0,false);
		cvarCaptureBlockedKarma = CreateConVar("atac_captureblockkarma","2","Amount of karma to award for preventing a point capture",FCVAR_PLUGIN,true,0.0,false);
		cvarBombPlantedKarma = CreateConVar("atac_bombplantedkarma","1","Amount of karma to award for planting TNT",FCVAR_PLUGIN,true,0.0,false);
		cvarBombExplodedKarma = CreateConVar("atac_bombexplodedkarma","2","Amount of karma to award for TNT successfully exploding",FCVAR_PLUGIN,true,0.0,false);
		cvarBombDefusedKarma = CreateConVar("atac_bombdefusedkarma","2","Amount of karma to award for defusing TNT",FCVAR_PLUGIN,true,0.0,false);
		cvarKillPlanterKarma = CreateConVar("atac_killplanterkarma","1","Amount of karma to award for killing bomb planter (during plant)",FCVAR_PLUGIN,true,0.0,false);
		cvarKillDefuserKarma = CreateConVar("atac_killdefuserkarma","1","Amount of karma to award for killing bomb defuser (during defuse)",FCVAR_PLUGIN,true,0.0,false);
		cvarRoundWinKarma = CreateConVar("atac_roundwinkarma","2","Amount of karma to award for team winning the round",FCVAR_PLUGIN,true,0.0,false);
		cvarATACProtectionTimer = CreateConVar("atac_spawnprotection","10","Time, in seconds, until spawn protection expires.\nMin: 0\nMax: 30",FCVAR_PLUGIN,true,0.0,true,30.0);
		cvarATACMirrorDamage = CreateConVar("atac_mirrordamage","1","Enables/disables mirroring damage on a team attack.",FCVAR_PLUGIN,true,0.0,true,1.0);
		cvarATACHealMirrorDamage = CreateConVar("atac_healmirrordamage","0","If mirror damage is on, this will also heal the damage done to the victim\nThis does not prevent headshot TKs",FCVAR_PLUGIN,true,0.0,true,1.0);
		cvarATACMirrorDamageSlap = CreateConVar("atac_mirrordamageslap","0","If mirror damage is on this will use slapping instead of just health change.",FCVAR_PLUGIN,true,0.0,true,1.0);
		AutoExecConfig(true,"atac_dods","sourcemod");
	}
}

public OnATACLoaded(){
	cvarATACAdminImmunity = FindConVar("atac_immunity");
	cvarATACIgnoreBots = FindConVar("atac_ignorebots");
	HookEvent("dod_point_captured",ev_PointCaptured);
	HookEvent("dod_capture_blocked",ev_CaptureBlocked);
	HookEvent("dod_bomb_planted",ev_BombPlanted);
	HookEvent("dod_bomb_exploded",ev_BombExploded);
	HookEvent("dod_bomb_defused",ev_BombDefused);
	HookEvent("dod_kill_planter",ev_KillPlanter);
	HookEvent("dod_kill_defuser",ev_KillDefuser);
	HookEvent("dod_round_win",ev_RoundWin);
	HookEvent("player_hurt",ev_PlayerHurt);
	HookEvent("player_spawn",ev_PlayerSpawn);
}

public OnMapStart()
{
	g_Lightning = PrecacheModel("materials/sprites/tp_beam001.vmt", false);
	g_ExplosionFire = PrecacheModel("materials/effects/fire_cloud1.vmt",false);
	g_Smoke1 = PrecacheModel("materials/effects/fire_cloud1.vmt",false);
	g_Smoke2 = PrecacheModel("materials/effects/fire_cloud2.vmt",false);
	g_FireBurst = PrecacheModel("materials/sprites/fireburst.vmt",false);
	PrecacheSound("ambient/explosions/explode_8.wav",false);
	PrecacheSound("player/pl_fallpain1.wav",false);
	PrecacheSound("ambient/atmosphere/terrain_rumble1.wav",false);
	if(g_Lightning == 0 || g_Smoke1 == 0 || g_Smoke2 == 0 || g_FireBurst == 0 || g_ExplosionFire == 0 || !IsSoundPrecached("player/pl_fallpain1.wav") || !IsSoundPrecached("ambient/explosions/explode_8.wav") || !IsSoundPrecached("ambient/atmosphere/terrain_rumble1.wav")){
		SetFailState("[ATAC] DoD: Source Precache Failed");
	}
}

stock SetClientHealth(client, amount)
{
	new HPOffs = FindDataMapOffs(client,"m_iHealth");
	SetEntData(client,HPOffs,amount,true);
}

TextOutput(attacker,victim,const String:Phrase[]){
	if(IsClientInGame(attacker) && IsClientInGame(victim)){
		decl String:attackerName[64];
		decl String:victimName[64];
		GetClientName(attacker,attackerName,sizeof(attackerName));
		GetClientName(victim,victimName,sizeof(victimName));
		new Verbose = ATACGetVerbose();
		
		if(Verbose == 1){
			PrintToConsole(victim,"[ATAC] %t",Phrase,attackerName,victimName);
			PrintToChat(victim,"%c[ATAC]%c %t",GREEN,YELLOW,Phrase,attackerName,victimName);
			PrintToConsole(attacker,"[ATAC] %t",Phrase,attackerName,victimName);
			PrintToChat(attacker,"%c[ATAC]%c %t",GREEN,YELLOW,Phrase,attackerName,victimName);
		}else if(Verbose == 2){
			for(new players = 1; players <= GetMaxClients(); ++players){
				if(IsClientConnected(players) && IsClientInGame(players) && GetClientTeam(players) == GetClientTeam(victim)){
					PrintToConsole(players,"[ATAC] %t",Phrase,attackerName,victimName);
					PrintToChat(players,"%c[ATAC]%c %t",GREEN,YELLOW,Phrase,attackerName,victimName);
				}
			}
		}else if(Verbose == 3){
			for(new players = 1; players <= GetMaxClients(); ++players){
				if(IsClientConnected(players) && IsClientInGame(players) && GetUserAdmin(players) != INVALID_ADMIN_ID || GetClientTeam(players) == GetClientTeam(victim)){
					PrintToConsole(players,"[ATAC] %t",Phrase,attackerName,victimName);
					PrintToChat(players,"%c[ATAC]%c %t",GREEN,YELLOW,Phrase,attackerName,victimName);
				}
			}
		}else if(Verbose == 4){
			for(new players = 1; players <= GetMaxClients(); ++players){
				if(IsClientConnected(players) && IsClientInGame(players) && GetUserAdmin(players) != INVALID_ADMIN_ID || players == victim && players == attacker){
					PrintToConsole(players,"[ATAC] %t",Phrase,attackerName,victimName);
					PrintToChat(players,"%c[ATAC]%c %t",GREEN,YELLOW,Phrase,attackerName,victimName);
				}
			}
		}else if(Verbose == 5){
			for(new players = 1; players <= GetMaxClients(); ++players){
				if(IsClientConnected(players) && IsClientInGame(players) && GetUserAdmin(players) != INVALID_ADMIN_ID){
					PrintToConsole(players,"[ATAC] %t",Phrase,attackerName,victimName);
					PrintToChat(players,"%c[ATAC]%c %t",GREEN,YELLOW,Phrase,attackerName,victimName);
				}
			}
		}else if(Verbose == 6){
			for(new players = 1; players <= GetMaxClients(); ++players){
				if(IsClientConnected(players) && IsClientInGame(players)){
					PrintToConsole(players,"[ATAC] %t",Phrase,attackerName,victimName);
				}
			}
			PrintToChatAll("%c[ATAC]%c %t",GREEN,YELLOW,Phrase,attackerName,victimName);
		}
	}
}

stock SlayEffects(client)
{
	new Float:playerpos[3];
	GetClientAbsOrigin(client,playerpos);
	new Float:toppos[3];
	toppos[0] = playerpos[0];
	toppos[1] = playerpos[1];
	toppos[2] = playerpos[2]+1000;
	new lightningcolor[4];
	lightningcolor[0] = 255;
	lightningcolor[1] = 255;
	lightningcolor[2] = 255;
	lightningcolor[3] = 255;
	new Float:lightninglife = 2.0;
	new Float:lightningwidth = 5.0;
	new Float:lightningendwidth = 5.0;
	new lightningstartframe = 0;
	new lightningframerate = 1;
	new lightningfadelength = 1;
	new Float:lightningamplitude = 1.0;
	new lightningspeed = 250;
	
	new Float:smokescale = 50.0;
	new smokeframerate = 2;
	
	new Float:SmokePos[3];
	SmokePos[0] = playerpos[0];
	SmokePos[1] = playerpos[1];
	SmokePos[2] = playerpos[2] + 10;
	
	new Float:PlayerHeadPos[3];
	PlayerHeadPos[0] = playerpos[0];
	PlayerHeadPos[1] = playerpos[1];
	PlayerHeadPos[2] = playerpos[2] + 100;
	
	new Float:direction[3];
	direction[0] = 0.0;
	direction[1] = 0.0;
	direction[2] = 0.0;
	
	new Float:sparkstart[3];
	sparkstart[0] = playerpos[0];
	sparkstart[1] = playerpos[1];
	sparkstart[2] = playerpos[2] + 13.0;
	
	new Float:sparkdir[3];
	sparkdir[0] = playerpos[0];
	sparkdir[1] = playerpos[1];
	sparkdir[2] = playerpos[2] + 23.0;
	
	new Float:normal[3];
	normal[0] = 0.0;
	normal[1] = 0.0;
	normal[2] = 1.0;
	
	TE_SetupBeamPoints(toppos, playerpos, g_Lightning, g_Lightning, lightningstartframe, lightningframerate, lightninglife, lightningwidth, lightningendwidth, lightningfadelength, lightningamplitude, lightningcolor, lightningspeed);
	TE_SetupExplosion(playerpos, g_ExplosionFire, 10.0, 10, TE_EXPLFLAG_NONE,15,15);
	TE_SetupSmoke(playerpos, g_Smoke1, smokescale, smokeframerate);
	TE_SetupSmoke(playerpos, g_Smoke2, smokescale, smokeframerate);
	TE_SetupMetalSparks(sparkstart,sparkdir);
	
	TE_SendToAll(0.0);
	EmitAmbientSound("ambient/explosions/explode_8.wav", playerpos, SOUND_FROM_WORLD, SNDLEVEL_NORMAL, SND_NOFLAGS, 1.0, SNDPITCH_NORMAL, 0.0);
}

public ev_PlayerSpawn(Handle:event, const String:name[], bool:dontBroadcast){
	new userid = GetEventInt(event,"userid");
	new client = GetClientOfUserId(userid);
	new ProtectTime = GetConVarInt(cvarATACProtectionTimer);
	if(ProtectTime>0){
		g_SpawnTime[client] = GetTime();
	}
}

public ev_PlayerHurt(Handle:event, const String:name[], bool:dontBroadcast){
	new userid = GetEventInt(event,"userid");
	new userid2 = GetEventInt(event,"attacker");
	new victim = GetClientOfUserId(userid);
	new attacker = GetClientOfUserId(userid2);
	if(attacker != 0 && victim != 0){
		if(GetClientTeam(attacker) == GetClientTeam(victim) && victim != attacker){
			new bool:ImmunityOn = GetConVarBool(cvarATACAdminImmunity);
			new attackerFlags = GetUserFlagBits(attacker);
			if(ImmunityOn && (attackerFlags & ADMFLAG_CUSTOM6 || attackerFlags & ADMFLAG_ROOT)){
				return;
			}else{
				new ProtectTime = GetConVarInt(cvarATACProtectionTimer);
				if(ProtectTime>0){
					new queryTime = GetTime();
					if((queryTime-g_SpawnTime[victim])<=ProtectTime && IsClientConnected(attacker) && IsClientConnected(victim)){
						SlayEffects(attacker);
						ForcePlayerSuicide(attacker);
		
						new healthDmg = GetEventInt(event,"damage");
						
						new currentHealth = GetClientHealth(victim);
						
						new fixedHealth = currentHealth + healthDmg;
						
						if(fixedHealth > 100){
							SetClientHealth(victim,100);
						}else{
							SetClientHealth(victim,fixedHealth);
						}
						
						TextOutput(attacker,victim,"Spawn Attack");
						
					}
				}
				if(GetConVarBool(cvarATACMirrorDamage)){
					HandleMirrorDamage(GetEventInt(event,"health"),GetEventInt(event,"damage"),victim,attacker);
				}
			}
		}
	}
}

HandleMirrorDamage(newHealth,lostHealth,victim,attacker){
	if(GetClientTeam(attacker) == GetClientTeam(victim)){
		new bool:IgnoreBots = GetConVarBool(cvarATACIgnoreBots);
		if(IgnoreBots){
			if(IsFakeClient(victim) || IsFakeClient(attacker)){
				return;
			}
		}
		if(GetConVarBool(cvarATACHealMirrorDamage)){
			new newVictimHealth = newHealth + lostHealth;
			if(newVictimHealth > 100){
				SetClientHealth(victim,100);
			}else{
				SetClientHealth(victim,newVictimHealth);
			}
		}
		new bool:SlapOn = GetConVarBool(cvarATACMirrorDamageSlap);
		new attackerHealth = GetClientHealth(attacker);
		new newAttackerHealth = attackerHealth - lostHealth;
		if(newAttackerHealth <= 0){
			SlayEffects(attacker);
			ForcePlayerSuicide(attacker);
		}else{
			if(SlapOn){
				SlapPlayer(attacker,lostHealth);
			}else{
				SetClientHealth(attacker,newAttackerHealth);
			}
		}
	}
}

public ev_PointCaptured(Handle:event, const String:name[], bool:dontBroadcast){
	if(!GetEventBool(event,"bomb")){
		new karmaPoints = GetConVarInt(cvarPointCaptureKarma);
		new maxKarma = ATACGetMax(KARMA);
		if(maxKarma != 0 && karmaPoints > 0){
			decl String:Cappers[256];
			GetEventString(event,"cappers",Cappers,sizeof(Cappers));
			new capperlen = strlen(Cappers);
			for(new i; i < capperlen; i++){
				new target = Cappers[i];
				if(ATACGetClient(TEAMKILLS,target) > 0){
					new currKarma = ATACGetClient(KARMA,target);
					new newKarma = currKarma + karmaPoints;
					if(!ATACSetClient(KARMA,target,newKarma)){
							PrintToChat(target,"%c[ATAC]%c %t %t",GREEN,YELLOW,"Earned Karma",newKarma,maxKarma,"Capture Point");
					}
				}
			}
		}
	}
}

public ev_CaptureBlocked(Handle:event, const String:name[], bool:dontBroadcast){
	new karmaPoints = GetConVarInt(cvarCaptureBlockedKarma);
	new maxKarma = ATACGetMax(KARMA);
	if(maxKarma != 0 && karmaPoints > 0 ){
		new blocker = GetClientOfUserId(GetEventInt(event,"blocker"));
		if(blocker != 0 && ATACGetClient(TEAMKILLS,blocker) > 0){
			new currKarma = ATACGetClient(KARMA,blocker);
			new newKarma = currKarma + karmaPoints;
			if(!ATACSetClient(KARMA,blocker,newKarma)){
				PrintToChat(blocker,"%c[ATAC]%c %t %t",GREEN,YELLOW,"Earned Karma",newKarma,maxKarma,"Block Capture");
			}
		}
	}
}

public ev_BombPlanted(Handle:event, const String:name[], bool:dontBroadcast){
	new karmaPoints = GetConVarInt(cvarBombPlantedKarma);
	new maxKarma = ATACGetMax(KARMA);
	if(maxKarma != 0 && karmaPoints > 0 ){
		new planter = GetClientOfUserId(GetEventInt(event,"userid"));
		if(ATACGetClient(TEAMKILLS,planter) > 0){
			new currKarma = ATACGetClient(KARMA,planter);
			new newKarma = currKarma + karmaPoints;
			if(!ATACSetClient(KARMA,planter,newKarma)){
				PrintToChat(planter,"%c[ATAC]%c %t %t",GREEN,YELLOW,"Earned Karma",newKarma,maxKarma,"Plant TNT");
			}
		}
	}
}

public ev_BombExploded(Handle:event, const String:name[], bool:dontBroadcast){
	new karmaPoints = GetConVarInt(cvarBombExplodedKarma);
	new maxKarma = ATACGetMax(KARMA);
	if(maxKarma != 0 && karmaPoints > 0 ){
		new planter = GetClientOfUserId(GetEventInt(event,"userid"));
		if(ATACGetClient(TEAMKILLS,planter)){
			new currKarma = ATACGetClient(KARMA,planter);
			new newKarma = currKarma + karmaPoints;
			if(!ATACSetClient(KARMA,planter,newKarma)){
				PrintToChat(planter,"%c[ATAC] %t %t",GREEN,YELLOW,"Earned Karma",newKarma,maxKarma,"TNT Detonate");
			}
		}
	}
}

public ev_BombDefused(Handle:event, const String:name[], bool:dontBroadcast){
	new karmaPoints = GetConVarInt(cvarBombDefusedKarma);
	new maxKarma = ATACGetMax(KARMA);
	if(maxKarma != 0 && karmaPoints > 0 ){
		new defuser = GetClientOfUserId(GetEventInt(event,"userid"));
		new currKarma = ATACGetClient(KARMA,defuser);
		new newKarma = currKarma + karmaPoints;
		if(!ATACSetClient(KARMA,defuser,newKarma)){
			PrintToChat(defuser,"%c[ATAC]%c %t %t",GREEN,YELLOW,"Earned Karma",newKarma,maxKarma,"Defuse TNT");
		}
	}
}

public ev_KillPlanter(Handle:event, const String:name[], bool:dontBroadcast){
	new karmaPoints = GetConVarInt(cvarKillPlanterKarma);
	new maxKarma = ATACGetMax(KARMA);
	if(maxKarma != 0 && karmaPoints > 0 ){
		new attacker = GetClientOfUserId(GetEventInt(event,"userid"));
		new currKarma = ATACGetClient(KARMA,attacker);
		new newKarma = currKarma + karmaPoints;
		if(!ATACSetClient(KARMA,attacker,newKarma)){
			PrintToChat(attacker,"%c[ATAC]%c %t %t",GREEN, YELLOW,"Earned Karma", newKarma,maxKarma,"Killing Planter");
		}
	}
}

public ev_KillDefuser(Handle:event, const String:name[], bool:dontBroadcast){
	new karmaPoints = GetConVarInt(cvarKillDefuserKarma);
	new maxKarma = ATACGetMax(KARMA);
	if(maxKarma != 0 && karmaPoints > 0 ){
		new attacker = GetClientOfUserId(GetEventInt(event,"userid"));
		new currKarma = ATACGetClient(KARMA,attacker);
		new newKarma = currKarma + karmaPoints;
		if(!ATACSetClient(KARMA,attacker,newKarma)){
			PrintToChat(attacker,"%c[ATAC]%c %t %t",GREEN, YELLOW,"Earned Karma", newKarma,maxKarma,"Killing Defuser");
		}
	}
}

public ev_RoundWin(Handle:event, const String:name[], bool:dontBroadcast){
	new karmaPoints = GetConVarInt(cvarRoundWinKarma);
	new maxKarma = ATACGetMax(KARMA);
	if(maxKarma != 0 && karmaPoints > 0 ){
		new WinningTeam = GetEventInt(event,"team");
		if(WinningTeam < 1) return;
		for(new player = 1; player <= GetMaxClients(); ++player){
			if(IsClientInGame(player) && GetClientTeam(player) == WinningTeam){
				if(ATACGetClient(TEAMKILLS,player) > 0){
					new currKarma = ATACGetClient(KARMA,player);
					new newKarma = currKarma + karmaPoints;
					if(!ATACSetClient(KARMA,player,newKarma)){
						PrintToChat(player,"%c[ATAC]%c %t %t",GREEN, YELLOW,"Earned Karma", newKarma,maxKarma,"Winning Round");
					}
				}
			}
		}
	}
}