#pragma semicolon 1
#pragma dynamic 65536
#define REQUIRE_PLUGIN
#include <sourcemod>
#undef REQUIRE_PLUGIN
#include <atac>
#define REQUIRE_EXTENSIONS
#include <sdktools>
#undef REQUIRE_EXTENSIONS

#define YELLOW 0x01
#define TEAMCOLOR 0x03
#define GREEN 0x04
#define ATAC_VERSION "2.5.0"

#include <sourcemod>
#include <atac>

new bool:BurnNextSpawn[MAXPLAYERS+1];
new bool:punished[MAXPLAYERS+1][MAXPLAYERS+1];
new Handle:Punishment;
new Handle:BurnDelayTimer[MAXPLAYERS+1] = INVALID_HANDLE;

public Plugin:myinfo = 
{
	name = "ATAC Punishment Burn",
	author = "FlyingMongoose",
	description = "Based on basefuncommands burn",
	version = ATAC_VERSION,
	url = "FlyingMongoose"
}

public OnPluginStart()
{
	LoadTranslations("atac.phrases");
	LoadTranslations("atac_burn.phrases");
}

public OnATACLoaded(){
	HookEvent("player_death",ev_PlayerDeath);
	HookEvent("player_spawn",ev_PlayerSpawn);
	decl String:BurnStr[128];
	Format(BurnStr,sizeof(BurnStr),"%t","Menu Burn");
	Punishment = RegisterPunishment("MenuBurn",BurnStr);
}

public OnPluginEnd(){
	UnregisterPunishment(Punishment);
}

public Action:MenuBurn(victim,attacker)
{
	if(attacker != 0 && victim != 0){
		if(IsClientInGame(attacker)){
			new CurrTKValue = ATACGetClient(TEAMKILLS,attacker);
			new newTKValue = CurrTKValue + 1;
			ATACSetClient(TEAMKILLS,attacker,newTKValue);
			decl String:attackerName[64];
			GetClientName(attacker,attackerName,sizeof(attackerName));
			if(IsClientConnected(attacker) && IsPlayerAlive(attacker)){
				punished[attacker][victim] = true;
				BurnClient(attacker,victim);
				return Plugin_Handled;
			}else{
				PrintToConsole(victim,"[ATAC] %t","Burn Next Spawn",attackerName);
				PrintToChat(victim,"%c[ATAC]%c %t",GREEN,YELLOW,"Burn Next Spawn",attackerName);
				BurnNextSpawn[attacker] = true;
				punished[attacker][victim] = true;
				return Plugin_Handled;
			}
		}
	}
	return Plugin_Continue;
}

public Action:BurnDelay(Handle:timer){
	decl String:attackerName[64];
	for(new attacker = 1; attacker <= GetMaxClients(); ++attacker){
		if(IsClientConnected(attacker) && IsClientInGame(attacker) && BurnNextSpawn[attacker]){
			GetClientName(attacker,attackerName,sizeof(attackerName));
			for(new victim = 1; victim <= GetMaxClients(); ++victim){
				if (punished[attacker][victim]){
					BurnClient(attacker,victim);
					punished[attacker][victim] = false;
				}
			}
		}
		BurnNextSpawn[attacker] = false;
	}
	return Plugin_Handled;
}

public Action:BurnClient(attacker,victim)
{
	decl String:attackerName[64];
	GetClientName(attacker,attackerName,64);
	PrintToConsole(victim,"[ATAC] %t","Been Burned",attackerName,ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	PrintToChat(victim,"%c[ATAC]%c %t",GREEN,YELLOW,"Been Burned",attackerName,ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	PrintToConsole(attacker,"[ATAC] %t","Were Burned",ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	PrintToChat(attacker,"%c[ATAC]%c %t",GREEN,YELLOW,"Were Burned",ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	ServerCommand("sm_burn %s",attackerName);
	return Plugin_Handled;
}

public ev_PlayerSpawn(Handle:event, const String:name[], bool:dontBroadcast)
{
	
	new client = GetClientOfUserId(GetEventInt(event, "userid"));

	if(BurnNextSpawn[client])
	{
		BurnDelayTimer[client] = CreateTimer(float(ATACGetPunishDelay()), BurnDelay, client);
		BurnNextSpawn[client] = false;
	}
}

public ev_PlayerDeath(Handle:event, const String:name[], bool:dontBroadcast)
{
	new client = GetClientOfUserId(GetEventInt(event,"userid"));
	ExtinguishEntity(client);
}

public OnClientDisconnect(client)
{
	for(new victim = 1; victim <= GetMaxClients(); ++victim){
		if (punished[client][victim]){
			BurnClient(client,victim);
			punished[client][victim] = false;
		}
	}
	if(BurnNextSpawn[client])
		BurnNextSpawn[client] = false;
	
	if(BurnDelayTimer[client] != INVALID_HANDLE){
		KillTimer(BurnDelayTimer[client],true);
		BurnDelayTimer[client] = INVALID_HANDLE;
	}
}