#pragma semicolon 1
#pragma dynamic 65536
#define REQUIRE_PLUGIN
#include <sourcemod>
#undef REQUIRE_PLUGIN
#include <atac>
#define REQUIRE_EXTENSIONS
#include <sdktools>
#undef REQUIRE_EXTENSIONS

#define YELLOW 0x01
#define TEAMCOLOR 0x03
#define GREEN 0x04
#define ATAC_VERSION "2.5.0"

#include <sourcemod>
#include <atac>

new bool:BlindNextSpawn[MAXPLAYERS+1];
new bool:punished[MAXPLAYERS+1][MAXPLAYERS+1];
new Handle:Punishment;
new Handle:TimerHandle[MAXPLAYERS+1] = INVALID_HANDLE;

public Plugin:myinfo = 
{
	name = "ATAC Punishment Blind",
	author = "FlyingMongoose",
	description = "Based on basefuncommands blind",
	version = ATAC_VERSION,
	url = "FlyingMongoose"
}

public OnPluginStart()
{
	LoadTranslations("atac.phrases");
	LoadTranslations("atac_blind.phrases");
}

public OnATACLoaded(){
	HookEvent("player_spawn",ev_PlayerSpawn);
	decl String:BlindStr[128];
	Format(BlindStr,sizeof(BlindStr),"%t","Menu Blind");
	Punishment = RegisterPunishment("MenuBlind",BlindStr);
}

public OnPluginEnd(){
	UnregisterPunishment(Punishment);
}

public Action:MenuBlind(victim,attacker)
{
	if(attacker != 0 && victim != 0){
		if(IsClientInGame(attacker)){
			new CurrTKValue = ATACGetClient(TEAMKILLS,attacker);
			new newTKValue = CurrTKValue + 1;
			ATACSetClient(TEAMKILLS,attacker,newTKValue);
			decl String:attackerName[64];
			GetClientName(attacker,attackerName,sizeof(attackerName));
			if(IsClientConnected(attacker) && IsPlayerAlive(attacker)){
				punished[attacker][victim] = true;
				BlindClient(attacker,victim);
				return Plugin_Handled;
			}else{
				PrintToConsole(victim,"[ATAC] %t","Blind Next Spawn",attackerName);
				PrintToChat(victim,"%c[ATAC]%c %t",GREEN,YELLOW,"Blind Next Spawn",attackerName);
				BlindNextSpawn[attacker] = true;
				punished[attacker][victim] = true;
				return Plugin_Handled;
			}
		}
	}
	return Plugin_Continue;
}

public Action:BlindDelay(Handle:timer){
	decl String:attackerName[64];
	for(new attacker = 1; attacker <= GetMaxClients(); ++attacker){
		if(IsClientConnected(attacker) && IsClientInGame(attacker) && BlindNextSpawn[attacker]){
			GetClientName(attacker,attackerName,sizeof(attackerName));
			for(new victim = 1; victim <= GetMaxClients(); ++victim){
				if (punished[attacker][victim]){
					BlindClient(attacker,victim);
					punished[attacker][victim] = false;
				}
			}
		}
		BlindNextSpawn[attacker] = false;
	}
	return Plugin_Handled;
}

public Action:BlindClient(attacker,victim)
{
	decl String:attackerName[64];
	GetClientName(attacker,attackerName,64);
	PrintToConsole(victim,"[ATAC] %t","Been Blinded",attackerName,ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	PrintToChat(victim,"%c[ATAC]%c %t",GREEN,YELLOW,"Been Blinded",attackerName,ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	PrintToConsole(attacker,"[ATAC] %t","Were Blinded",ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	PrintToChat(attacker,"%c[ATAC]%c %t",GREEN,YELLOW,"Were Blinded",ATACGetClient(TEAMKILLS,attacker),ATACGetMax(TEAMKILLS));
	ServerCommand("sm_blind %s 255",attackerName);
	return Plugin_Handled;
}

public ev_PlayerSpawn(Handle:event, const String:name[], bool:dontBroadcast)
{
	new client = GetClientOfUserId(GetEventInt(event,"userid"));
	if(IsClientConnected(client) && BlindNextSpawn[client]){
		new Float:delay = float(ATACGetPunishDelay());
		TimerHandle[client] = CreateTimer(delay,BlindDelay);
	}
}

public OnClientDisconnect(client)
{
	for(new victim = 1; victim <= GetMaxClients(); ++victim){
		if (punished[client][victim]){
			punished[client][victim] = false;
		}
	}
	if(BlindNextSpawn[client])
		BlindNextSpawn[client] = false;
	if(TimerHandle[client] != INVALID_HANDLE)
	{
		KillTimer(TimerHandle[client],true);
		TimerHandle[client] = INVALID_HANDLE;
	}
}