#pragma semicolon 1
#pragma dynamic 65536
#define REQUIRE_PLUGIN
#include <sourcemod>
#undef REQUIRE_PLUGIN
#include <atac>
#define REQUIRE_EXTENSIONS
#include <sdktools>
#undef REQUIRE_EXTENSIONS

#define YELLOW 0x01
#define TEAMCOLOR 0x03
#define GREEN 0x04
#define ATAC_VERSION "2.5.0"

#define BEACON_DELAY 1.5

public Plugin:myinfo =
{
	name = "ATAC Punishment Beacon",
	author = "dalto",
	description = "Beacon punishment for ATAC",
	version = ATAC_VERSION,
	url = "http://www.steamfriends.com/"
};

new Handle:g_hBeaconList[MAXPLAYERS + 1];
new Handle:BeaconDelayTimer[MAXPLAYERS + 1] = INVALID_HANDLE;
new bool:BeaconNextSpawn[MAXPLAYERS + 1];
new Handle:g_CvarBeaconSound;
new String:g_soundName[PLATFORM_MAX_PATH];
new g_victimList[MAXPLAYERS + 1];
new g_beamSprite;
new g_haloSprite;

new Handle:Punishment;

public OnPluginStart(){
	LoadTranslations("atac.phrases");
	LoadTranslations("atac_beacon.phrases");
	g_CvarBeaconSound = CreateConVar("sm_atac_beacon_sound", "buttons/blip1.wav", "The sound to play for the beacon");
	AutoExecConfig(true,"atac_beacon","sourcemod");
}

public OnATACLoaded()
{
	HookEvent("player_spawn", ev_PlayerSpawn);
	HookEvent("player_death", ev_PlayerDeath);
	decl String:Beacon[128];
	Format(Beacon,sizeof(Beacon),"%t","Menu Beacon");
	Punishment = RegisterPunishment("MenuBeacon",Beacon);
}

public OnPluginEnd(){
	UnregisterPunishment(Punishment);
}

public OnMapStart()
{
	decl String:buffer[PLATFORM_MAX_PATH];
	GetConVarString(g_CvarBeaconSound, g_soundName, sizeof(g_soundName));
	if(strcmp(g_soundName, ""))
	{
		PrecacheSound(g_soundName, true);
		Format(buffer, sizeof(buffer), "sound/%s", g_soundName);
		AddFileToDownloadsTable(buffer);
	}
	g_beamSprite = PrecacheModel("materials/sprites/laser.vmt");
	g_haloSprite = PrecacheModel("materials/sprites/halo01.vmt");
}

public MenuBeacon(victim, attacker)
{
	new CurrTKValue = ATACGetClient(TEAMKILLS, attacker);
	new newTKValue = CurrTKValue + 1;
	ATACSetClient(TEAMKILLS, attacker, newTKValue);
	if(attacker && IsClientInGame(attacker))
	{
		g_victimList[attacker] = victim;
		decl String:attackerName[64];
		GetClientName(attacker, attackerName, sizeof(attackerName));
		if(IsPlayerAlive(attacker))
		{
			BeaconPlayer(attacker);
		} else {
			PrintToConsole(victim, "[ATAC] %t","Beacon Next Round", attackerName);
			PrintToChat(victim, "%c[ATAC]%c %t", GREEN, YELLOW,"Beacon Next Round", attackerName);
			BeaconNextSpawn[attacker] = true;
		}
	}
}

public ev_PlayerDeath(Handle:event, const String:name[], bool:dontBroadcast)
{
	new client = GetClientOfUserId(GetEventInt(event, "userid"));

	if(g_hBeaconList[client] != INVALID_HANDLE)
	{
		KillTimer(g_hBeaconList[client]);
		g_hBeaconList[client] = INVALID_HANDLE;
	}
}

public BeaconPlayer(attacker)
{
	if(!attacker || !IsClientInGame(attacker))
	{
		return;
	}
	
	decl String:attackerName[64];
	GetClientName(attacker, attackerName, sizeof(attackerName));
	if(g_victimList[attacker] && IsClientInGame(g_victimList[attacker]))
	{
		PrintToConsole(g_victimList[attacker], "[ATAC] %t","Has Been Beaconed", attackerName, ATACGetClient(TEAMKILLS, attacker), ATACGetMax(TEAMKILLS));
		PrintToChat(g_victimList[attacker], "%c[ATAC]%c %t", GREEN, YELLOW, "Has Been Beaconed", attackerName, ATACGetClient(TEAMKILLS, attacker), ATACGetMax(TEAMKILLS));
	}
	PrintToConsole(attacker, "[ATAC] %t","You Were Beaconed", ATACGetClient(TEAMKILLS, attacker), ATACGetMax(TEAMKILLS));
	PrintToChat(attacker, "%c[ATAC]%c %t", GREEN, YELLOW, "You Were Beaconed", ATACGetClient(TEAMKILLS, attacker), ATACGetMax(TEAMKILLS));
	if(g_hBeaconList[attacker] != INVALID_HANDLE)
	{
		CloseHandle(g_hBeaconList[attacker]);
	}
	g_hBeaconList[attacker] = CreateTimer(BEACON_DELAY, BeaconTimer, attacker);
}
		
public ev_PlayerSpawn(Handle:event, const String:name[], bool:dontBroadcast)
{
	new client = GetClientOfUserId(GetEventInt(event, "userid"));

	if(g_hBeaconList[client] != INVALID_HANDLE)
	{
		KillTimer(g_hBeaconList[client]);
		g_hBeaconList[client] = INVALID_HANDLE;
	}

	if(BeaconNextSpawn[client])
	{
		BeaconDelayTimer[client] = CreateTimer(float(ATACGetPunishDelay()), BeaconDelay, client);
		BeaconNextSpawn[client] = false;
	}
}


public Action:BeaconDelay(Handle:timer, any:client)
{
	BeaconPlayer(client);
}

public Action:BeaconTimer(Handle:timer, any:client)
{
	new color[] = {255, 255, 255, 255};
	if(!client || !IsClientInGame(client) || !IsPlayerAlive(client))
	{
		return Plugin_Handled;
	}
	
	// create a beam effect and the anothor one immediately after
	BeamRing(client, color);
	CreateTimer(0.2, BeaconTimer2, client);
	if(strcmp(g_soundName, ""))
	{
		new Float:vec[3];
		GetClientEyePosition(client, vec);
		EmitAmbientSound(g_soundName, vec, client, SNDLEVEL_RAIDSIREN);
	}
	if(g_hBeaconList[client] != INVALID_HANDLE)
	{
		KillTimer(g_hBeaconList[client]);
		g_hBeaconList[client] = INVALID_HANDLE;
	}
	g_hBeaconList[client] = CreateTimer(BEACON_DELAY, BeaconTimer, client);
	return Plugin_Handled;
}

public Action:BeaconTimer2(Handle:timer, any:client)
{
	new color[] = {255, 255, 255, 255};
	if(!client || !IsClientInGame(client) || !IsPlayerAlive(client))
	{
		return Plugin_Handled;
	}
	
	BeamRing(client, color);
	
	return Plugin_Handled;
}

public BeamRing(client, color[4])
{
	new Float:vec[3];
	GetClientAbsOrigin(client, vec);
	vec[2] += 5;

	TE_Start("BeamRingPoint");
	TE_WriteVector("m_vecCenter", vec);
	TE_WriteFloat("m_flStartRadius", 20.0);
	TE_WriteFloat("m_flEndRadius", 400.0);
	TE_WriteNum("m_nModelIndex", g_beamSprite);
	TE_WriteNum("m_nHaloIndex", g_haloSprite);
	TE_WriteNum("m_nStartFrame", 0);
	TE_WriteNum("m_nFrameRate", 0);
	TE_WriteFloat("m_fLife", 1.0);
	TE_WriteFloat("m_fWidth", 6.0);
	TE_WriteFloat("m_fEndWidth", 12.0);
	TE_WriteFloat("m_fAmplitude", 0.0);
	TE_WriteNum("r", color[0]);
	TE_WriteNum("g", color[1]);
	TE_WriteNum("b", color[2]);
	TE_WriteNum("a", color[3]);
	TE_WriteNum("m_nSpeed", 50);
	TE_WriteNum("m_nFlags", 0);
	TE_WriteNum("m_nFadeLength", 0);
	TE_SendToAll();
}

public OnClientDisconnect(client)
{
	if(g_hBeaconList[client] != INVALID_HANDLE)
	{
		KillTimer(g_hBeaconList[client]);
		g_hBeaconList[client] = INVALID_HANDLE;
	}
	if(BeaconNextSpawn[client])
		BeaconNextSpawn[client] = false;
	if(BeaconDelayTimer[client] != INVALID_HANDLE)
	{
		KillTimer(BeaconDelayTimer[client]);
		BeaconDelayTimer[client] = INVALID_HANDLE;
	}
}